/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp.uploadfile;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.boot.jdkhttp.uploadfile.Header;
import org.noear.solon.boot.jdkhttp.uploadfile.Utils;

public class Headers
implements Iterable<Header> {
    protected Header[] headers = new Header[12];
    protected int count;

    public int size() {
        return this.count;
    }

    public String get(String name) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            return this.headers[i].getValue();
        }
        return null;
    }

    public boolean contains(String name) {
        return this.get(name) != null;
    }

    public void add(String name, String value) {
        Header header = new Header(name, value);
        if (this.count == this.headers.length) {
            Header[] expanded = new Header[2 * this.count];
            System.arraycopy(this.headers, 0, expanded, 0, this.count);
            this.headers = expanded;
        }
        this.headers[this.count++] = header;
    }

    public void addAll(Headers headers) {
        for (Header header : headers) {
            this.add(header.getName(), header.getValue());
        }
    }

    public Header replace(String name, String value) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.headers[i].getName().equalsIgnoreCase(name)) continue;
            Header prev = this.headers[i];
            this.headers[i] = new Header(name, value);
            return prev;
        }
        this.add(name, value);
        return null;
    }

    public void remove(String name) {
        int j = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.headers[i].getName().equalsIgnoreCase(name)) continue;
            this.headers[j++] = this.headers[i];
        }
        while (this.count > j) {
            this.headers[--this.count] = null;
        }
    }

    public Map<String, String> getParams(String name) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (String param : Utils.split(this.get(name), ";", -1)) {
            String[] pair = Utils.split(param, "=", 2);
            String val = pair.length == 1 ? "" : Utils.trimLeft(Utils.trimRight(pair[1], '\"'), '\"');
            params.put(pair[0], val);
        }
        return params;
    }

    @Override
    public Iterator<Header> iterator() {
        return Arrays.asList(this.headers).subList(0, this.count).iterator();
    }
}

