/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.auth;

import java.util.Collection;
import java.util.function.Consumer;
import org.noear.solon.Solon;
import org.noear.solon.auth.AuthFailureHandler;
import org.noear.solon.auth.AuthFailureHandlerDefault;
import org.noear.solon.auth.AuthProcessor;
import org.noear.solon.auth.AuthRule;
import org.noear.solon.auth.AuthRuleHandler;
import org.noear.solon.auth.impl.AuthRuleImpl;
import org.noear.solon.core.handle.Handler;

public class AuthAdapter {
    private String loginUrl;
    private String authRulePathPrefix;
    private AuthRuleHandler authRuleHandler;
    private AuthProcessor authProcessor;
    private AuthFailureHandler authFailure = new AuthFailureHandlerDefault();

    public String loginUrl() {
        return this.loginUrl;
    }

    public AuthAdapter loginUrl(String url) {
        this.loginUrl = url;
        return this;
    }

    public synchronized AuthAdapter addRule(Consumer<AuthRule> builder) {
        AuthRuleImpl rule = new AuthRuleImpl();
        builder.accept(rule);
        this.addRuleDo(rule);
        return this;
    }

    public AuthAdapter addRules(Collection<AuthRule> rules) {
        rules.forEach(r -> this.addRuleDo((AuthRule)r));
        return this;
    }

    private synchronized void addRuleDo(AuthRule rule) {
        if (this.authRuleHandler == null) {
            this.authRuleHandler = new AuthRuleHandler();
            this.authRuleHandler.setPathPrefix(this.authRulePathPrefix);
            Solon.app().before((Handler)this.authRuleHandler);
        }
        this.authRuleHandler.addRule(rule);
    }

    protected void setRulePathPrefix(String pathPrefix) {
        this.authRulePathPrefix = pathPrefix;
        if (this.authRuleHandler != null) {
            this.authRuleHandler.setPathPrefix(this.authRulePathPrefix);
        }
    }

    public AuthProcessor processor() {
        return this.authProcessor;
    }

    public AuthAdapter processor(AuthProcessor processor) {
        this.authProcessor = processor;
        return this;
    }

    public AuthFailureHandler failure() {
        return this.authFailure;
    }

    public AuthAdapter failure(AuthFailureHandler handler) {
        this.authFailure = handler;
        return this;
    }
}

