/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.auth;

import java.util.Collection;
import java.util.function.Consumer;
import org.noear.solon.Solon;
import org.noear.solon.annotation.Note;
import org.noear.solon.auth.AuthFailureHandler;
import org.noear.solon.auth.AuthProcessor;
import org.noear.solon.auth.AuthRule;
import org.noear.solon.auth.AuthRuleHandler;
import org.noear.solon.auth.impl.AuthRuleImpl;
import org.noear.solon.core.handle.Handler;

public class AuthAdapter {
    private String loginUrl;
    private AuthRuleHandler authRuleHandler;
    private AuthProcessor authProcessor;
    private AuthFailureHandler authFailure = (ctx, rst) -> ctx.render((Object)rst);

    public String loginUrl() {
        return this.loginUrl;
    }

    public AuthAdapter loginUrl(String url) {
        this.loginUrl = url;
        return this;
    }

    @Note(value="\u6dfb\u52a0\u4e00\u4e2a\u6388\u6743\u89c4\u5219")
    public synchronized AuthAdapter addRule(Consumer<AuthRule> builder) {
        AuthRuleImpl rule = new AuthRuleImpl();
        builder.accept(rule);
        this.addRuleDo(rule);
        return this;
    }

    public AuthAdapter addRules(Collection<AuthRule> rules) {
        rules.forEach(r -> this.addRuleDo((AuthRule)r));
        return this;
    }

    private synchronized void addRuleDo(AuthRule rule) {
        if (this.authRuleHandler == null) {
            this.authRuleHandler = new AuthRuleHandler();
            Solon.global().before((Handler)this.authRuleHandler);
        }
        this.authRuleHandler.rules().add(rule);
    }

    public AuthProcessor processor() {
        return this.authProcessor;
    }

    @Note(value="\u8bbe\u5b9a\u8ba4\u8bc1\u5904\u7406\u5668")
    public AuthAdapter processor(AuthProcessor processor) {
        this.authProcessor = processor;
        return this;
    }

    public AuthFailureHandler failure() {
        return this.authFailure;
    }

    @Note(value="\u8bbe\u5b9a\u9ed8\u8ba4\u7684\u9a8c\u8bc1\u51fa\u9519\u5904\u7406")
    public AuthAdapter failure(AuthFailureHandler handler) {
        this.authFailure = handler;
        return this;
    }
}

