/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.auth;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.auth.AuthAdapter;
import org.noear.solon.auth.AuthAdapterSupplier;
import org.noear.solon.auth.annotation.Logical;
import org.noear.solon.core.Aop;
import org.noear.solon.core.handle.Context;

public class AuthUtil {
    public static final String MESSAGE_OF_IP = " , this ip unauthorized";
    public static final String MESSAGE_OF_LOGINED = "Unauthorized";
    public static final String MESSAGE_OF_PATH = "Forbidden";
    public static final String MESSAGE_OF_PERMISSIONS = "No permission granted";
    public static final String MESSAGE_OF_ROLES = "No role granted";
    private static AuthAdapter adapter = new AuthAdapter();
    private static List<AuthAdapterSupplier> adapterSuppliers = new ArrayList<AuthAdapterSupplier>();

    public static AuthAdapter adapter() {
        if (adapterSuppliers.size() > 0) {
            Context ctx = Context.current();
            for (AuthAdapterSupplier a1 : adapterSuppliers) {
                if (!ctx.pathNew().startsWith(a1.pathPrefix())) continue;
                return a1.adapter();
            }
        }
        return adapter;
    }

    public static void adapterAdd(AuthAdapterSupplier supplier) {
        adapterSuppliers.add(supplier);
        adapterSuppliers.sort(Comparator.comparingInt(e -> -e.pathPrefix().length()));
    }

    public static void adapterRemove(AuthAdapterSupplier supplier) {
        adapterSuppliers.remove(supplier);
    }

    public static boolean verifyIp(String ip) {
        return AuthUtil.adapter().processor().verifyIp(ip);
    }

    public static boolean verifyLogined() {
        return AuthUtil.adapter().processor().verifyLogined();
    }

    public static boolean verifyPath(String path, String method) {
        if (AuthUtil.verifyLogined()) {
            return AuthUtil.adapter().processor().verifyPath(path, method);
        }
        return false;
    }

    public static boolean verifyPermissions(String ... permissions) {
        return AuthUtil.verifyPermissions(permissions, Logical.OR);
    }

    public static boolean verifyPermissionsAnd(String ... permissions) {
        return AuthUtil.verifyPermissions(permissions, Logical.AND);
    }

    public static boolean verifyPermissions(String[] permissions, Logical logical) {
        if (AuthUtil.verifyLogined()) {
            return AuthUtil.adapter().processor().verifyPermissions(permissions, logical);
        }
        return false;
    }

    public static boolean verifyRoles(String ... roles) {
        return AuthUtil.verifyRoles(roles, Logical.OR);
    }

    public static boolean verifyRolesAnd(String ... roles) {
        return AuthUtil.verifyRoles(roles, Logical.AND);
    }

    public static boolean verifyRoles(String[] roles, Logical logical) {
        if (AuthUtil.verifyLogined()) {
            return AuthUtil.adapter().processor().verifyRoles(roles, logical);
        }
        return false;
    }

    static {
        Aop.getAsyn(AuthAdapter.class, bw -> {
            adapter = (AuthAdapter)bw.raw();
        });
    }
}

