/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.webdav.impl;

import java.io.IOException;
import java.io.InputStream;

public class ShardingInputStream
extends InputStream {
    private InputStream in;
    private long length;
    private long hasLength;

    public ShardingInputStream(InputStream in, long start, long length) {
        this.in = in;
        this.length = length;
        this.hasLength = length;
        if (start > 0L) {
            long amt;
            for (long at = start; at > 0L; at -= amt) {
                try {
                    amt = this.in.skip(at);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.hasLength <= 0L) {
            return -1;
        }
        int r = this.in.read();
        --this.hasLength;
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("\u6b64\u6d41\u4e0d\u652f\u6301\u8df3\u8fc7");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.hasLength <= 0L) {
            return -1;
        }
        if (this.hasLength < (long)len) {
            len = (int)this.hasLength;
        }
        int c = this.in.read(b, off, len);
        this.hasLength -= (long)c;
        return c;
    }

    @Override
    public int available() {
        return (int)this.length;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mark(int readlimit) {
        throw new RuntimeException("\u6b64\u6d41\u4e0d\u652f\u6301\u6807\u8bb0");
    }

    @Override
    public void reset() {
        throw new RuntimeException("\u6b64\u6d41\u4e0d\u652f\u6301\u91cd\u7f6e");
    }
}

