/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.webdav;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.core.util.XmlUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.web.webdav.FileInfo;
import org.noear.solon.web.webdav.FileSystem;
import org.noear.solon.web.webdav.WebDavActionException;

public abstract class WebdavAbstractHandler
implements Handler {
    private boolean range;

    public WebdavAbstractHandler(boolean range) {
        this.range = range;
    }

    public abstract String user(Context var1);

    public abstract FileSystem fileSystem();

    public abstract String prefix();

    public void handle(Context ctx) {
        try {
            ctx.contentType("text/xml; charset=UTF-8");
            ctx.headerSet("Pragma", "no-cache");
            ctx.headerSet("Cache-Control", "no-cache");
            ctx.headerSet("X-DAV-BY", "webos");
            ctx.headerSet("Access-Control-Allow-Origin", "*");
            ctx.headerSet("Access-Control-Allow-Methods", "GET, POST, OPTIONS, DELETE, HEAD, MOVE, COPY, PUT, MKCOL, PROPFIND, PROPPATCH, LOCK, UNLOCK");
            ctx.headerSet("Access-Control-Allow-Headers", "ETag, Content-Type, Content-Length, Accept-Encoding, X-Requested-with, Origin, Authorization");
            ctx.headerSet("Access-Control-Allow-Credentials", "true");
            ctx.headerSet("Access-Control-Max-Age", "3600");
            if (StrUtil.isBlank((CharSequence)this.user(ctx))) {
                ctx.headerSet("WWW-Authenticate", "Basic realm=\"webos\"");
                ctx.status(401);
                return;
            }
            int status = 400;
            if (this.fileSystem() == null) {
                status = 500;
            } else {
                try {
                    switch (ctx.method()) {
                        case "OPTIONS": {
                            status = this.handleOptions(ctx);
                            break;
                        }
                        case "GET": 
                        case "HEAD": 
                        case "POST": {
                            status = this.handleGetHeadPost(ctx);
                            break;
                        }
                        case "DELETE": {
                            status = this.handleDelete(ctx);
                            break;
                        }
                        case "PUT": {
                            status = this.handlePut(ctx);
                            break;
                        }
                        case "MKCOL": 
                        case "KCOL": {
                            status = this.handleMkcol(ctx);
                            break;
                        }
                        case "COPY": 
                        case "MOVE": 
                        case "OVE": {
                            status = this.handleCopyMove(ctx);
                            break;
                        }
                        case "LOCK": {
                            status = this.handleLock(ctx);
                            break;
                        }
                        case "UNLOCK": {
                            status = this.handleUnlock(ctx);
                            break;
                        }
                        case "PROPFIND": {
                            status = this.handlePropfind(ctx);
                            break;
                        }
                        case "PROPPATCH": {
                            status = this.handleProppatch(ctx);
                        }
                    }
                }
                catch (WebDavActionException e) {
                    status = e.getCode();
                }
                catch (Exception e) {
                    status = 400;
                }
            }
            if (status == 0) {
                status = 200;
            }
            ctx.status(status);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int handleProppatch(Context ctx) {
        String reqPath = this.stripPrefix(ctx.path());
        String href = this.prefix() + "/" + reqPath;
        href = URLUtil.encode((String)href);
        String template = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<D:multistatus xmlns:D=\"DAV:\">\n\n\t\t<D:response>\n<D:href>{}</D:href>\n<D:propstat>\n\t<D:prop>\n\t\t<m:Win32LastAccessTime xmlns:m=\"urn:schemas-microsoft-com:\" />\n\t\t<m:Win32CreationTime xmlns:m=\"urn:schemas-microsoft-com:\" />\n\t\t<m:Win32LastModifiedTime xmlns:m=\"urn:schemas-microsoft-com:\" />\n\t\t<m:Win32FileAttributes xmlns:m=\"urn:schemas-microsoft-com:\" />\n\t</D:prop>\n\t<D:status>HTTP/1.1 200 OK</D:status>\n</D:propstat>\n\t\t</D:response>\n</D:multistatus>\n";
        ctx.output(StrUtil.format((CharSequence)template, (Object[])new Object[]{href}));
        return 207;
    }

    private int parseDepth(String s) {
        switch (s) {
            case "0": {
                return 0;
            }
            case "1": {
                return 1;
            }
            case "infinity": {
                return -1;
            }
        }
        return -2;
    }

    private int handlePropfind(Context ctx) throws Exception {
        String reqPath = this.stripPrefix(ctx.path());
        FileInfo fi = this.fileSystem().fileInfo(reqPath);
        if (fi == null) {
            return 404;
        }
        int depth = -1;
        String hdr = ctx.header("Depth");
        if (StrUtil.isNotBlank((CharSequence)hdr) && (depth = this.parseDepth(hdr)) == -2) {
            return 400;
        }
        if (depth == -1) {
            depth = 1;
        }
        String itemResponse = this.toItemResponse(reqPath, fi);
        if (!fi.isDir() || depth == 0) {
            ctx.output(this.toItemListResponse(itemResponse));
            return 207;
        }
        List<FileInfo> childs = this.fileSystem().fileList(reqPath);
        ArrayList list = CollUtil.newArrayList((Object[])new String[]{itemResponse});
        if (CollUtil.isNotEmpty(childs)) {
            for (FileInfo info : childs) {
                String tmp = StrUtil.isBlank((CharSequence)reqPath) ? info.name() : reqPath + "/" + info.name();
                list.add(this.toItemResponse(tmp, info));
            }
        }
        String out = this.toItemListResponse((String[])ArrayUtil.toArray((Collection)list, String.class));
        ctx.output(out);
        return 207;
    }

    private String toItemListResponse(String ... itemResponse) {
        String template = "<D:multistatus xmlns:D=\"DAV:\"> \n\t{}\n</D:multistatus>";
        StringBuilder sb = new StringBuilder();
        for (String tmp : itemResponse) {
            sb.append(tmp);
        }
        return StrUtil.format((CharSequence)template, (Object[])new Object[]{sb.toString()});
    }

    private String toItemResponse(String reqPath, FileInfo fi) {
        String template = "<D:response>\n<D:href>{}</D:href>\n<D:propstat>\n\t<D:prop>\n\t\t<D:getlastmodified>{}</D:getlastmodified>\n\t\t<D:creationdate>{}</D:creationdate>\n\t\t<D:getcontentlength>{}</D:getcontentlength>\n\t\t<D:resourcetype>{}</D:resourcetype><D:getcontenttype>{}</D:getcontenttype>\n\t</D:prop>\n\t<D:status>HTTP/1.1 200 OK</D:status>\n</D:propstat>\n\t</D:response>";
        String href = StrUtil.isBlank((CharSequence)reqPath) ? this.prefix() : this.prefix() + "/" + reqPath;
        href = URLUtil.encode((String)href);
        return StrUtil.format((CharSequence)template, (Object[])new Object[]{href, DateUtil.parse((CharSequence)fi.update()).toJdkDate().toString(), DateUtil.parse((CharSequence)fi.create()).toString("yyyy-MM-dd'T'HH:mm:ss'Z'"), fi.size(), fi.isDir() ? "<D:collection/>" : "", this.fileSystem().fileMime(fi)});
    }

    private int handleUnlock(Context ctx) {
        return 204;
    }

    private int handleLock(Context ctx) {
        try {
            Map map = XmlUtil.xmlToMap((String)ctx.body());
            String lockscope = StrUtil.subBetween((CharSequence)XmlUtil.mapToXmlStr((Map)((Map)map.get("D:lockscope"))), (CharSequence)"<xml>", (CharSequence)"</xml>");
            String locktype = StrUtil.subBetween((CharSequence)XmlUtil.mapToXmlStr((Map)((Map)map.get("D:locktype"))), (CharSequence)"<xml>", (CharSequence)"</xml>");
            String owner = StrUtil.subBetween((CharSequence)XmlUtil.mapToXmlStr((Map)((Map)map.get("D:owner"))), (CharSequence)"<xml>", (CharSequence)"</xml>");
            String token = IdUtil.fastSimpleUUID();
            ctx.headerSet("Lock-Token", "<" + token + ">");
            ctx.output(StrUtil.format((CharSequence)"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<D:prop xmlns:D=\"DAV:\"><D:lockdiscovery><D:activelock>\n\t<D:locktype>{}</D:locktype>\n\t<D:lockscope>{}</D:lockscope>\n\t<D:depth>infinity</D:depth>\n\t<D:owner>{}</D:owner>\n\t<D:timeout>Infinite</D:timeout>\n\t<D:locktoken><D:href>{}</D:href></D:locktoken>\n</D:activelock></D:lockdiscovery></D:prop>", (Object[])new Object[]{locktype, lockscope, owner, token}));
            return 200;
        }
        catch (Exception e) {
            return 400;
        }
    }

    private int handleCopyMove(Context ctx) {
        String descPath;
        String reqPath = this.stripPrefix(ctx.path());
        if (StrUtil.equals((CharSequence)reqPath, (CharSequence)(descPath = this.stripPrefix(ctx.header("Destination"))))) {
            return 403;
        }
        boolean flag = false;
        if (ctx.method().equals("COPY") || ctx.method().equals("OPY")) {
            flag = this.fileSystem().copy(reqPath, descPath);
        } else if (ctx.method().equals("MOVE") || ctx.method().equals("OVE")) {
            flag = this.fileSystem().move(reqPath, descPath);
        }
        return flag ? 201 : 404;
    }

    private int handleMkcol(Context ctx) {
        String reqPath = this.stripPrefix(ctx.path());
        boolean flag = this.fileSystem().mkdir(reqPath);
        return flag ? 201 : 405;
    }

    private int handlePut(Context ctx) throws Exception {
        long length = Convert.toLong((Object)ctx.header("Content-Length"), (Long)0L);
        boolean needLength = true;
        String chunked = ctx.header("Transfer-Encoding");
        if (StrUtil.isNotBlank((CharSequence)chunked) && StrUtil.equals((CharSequence)chunked.toLowerCase(), (CharSequence)"chunked")) {
            needLength = false;
        }
        if (needLength && length == 0L) {
            return 200;
        }
        String reqPath = this.stripPrefix(ctx.path());
        boolean flag = this.fileSystem().putFile(reqPath, ctx.bodyAsStream());
        return flag ? 204 : 405;
    }

    private int handleDelete(Context ctx) {
        String reqPath = this.stripPrefix(ctx.path());
        boolean flag = this.fileSystem().del(reqPath);
        if (!flag) {
            return 403;
        }
        return 0;
    }

    private int handleGetHeadPost(Context ctx) {
        InputStream resIn;
        String range;
        String reqPath = this.stripPrefix(ctx.path());
        String url = this.fileSystem().fileUrl(reqPath);
        if (StrUtil.isNotBlank((CharSequence)url)) {
            ctx.headerSet("Location", url);
            ctx.headerSet("Access-Control-Allow-Origin", "*");
            ctx.headerSet("Access-Control-Allow-Credentials", "true");
            ctx.headerSet("Access-Control-Allow-Methods", "*");
            ctx.headerSet("Access-Control-Allow-Headers", "*");
            ctx.headerSet("Access-Control-Expose-Headers", "*");
            ctx.headerSet("Access-Control-Max-Age", "86400");
            return 302;
        }
        FileInfo fi = this.fileSystem().fileInfo(reqPath);
        if (fi == null) {
            return 404;
        }
        if (fi.isDir()) {
            return 405;
        }
        String etag = this.fileSystem().findEtag(reqPath, fi);
        if (StrUtil.isBlank((CharSequence)etag)) {
            return 500;
        }
        ctx.headerSet("ETag", etag);
        ctx.headerSet("Last-Modified", DateUtil.parse((CharSequence)fi.update()).toJdkDate().toString());
        int type = 3;
        if (StrUtil.equals((CharSequence)ctx.method(), (CharSequence)"HEAD")) {
            type = 1;
        }
        long start = 0L;
        long end = 0L;
        if (type == 3 && StrUtil.isNotBlank((CharSequence)(range = ctx.header("Range")))) {
            type = 1;
            String[] sz = range.split("=")[1].split(",")[0].split("-");
            if (sz.length > 0) {
                start = Convert.toLong((Object)sz[0].trim());
                end = sz.length > 1 ? Convert.toLong((Object)sz[1].trim()) : fi.size() - 1L;
                type = 2;
            }
        }
        ctx.headerSet("Content-Type", "application/octet-stream");
        ctx.headerSet("Accept-Ranges", "bytes");
        ctx.headerSet("Content-Disposition", "attachment; filename=\"" + URLUtil.encodeAll((String)fi.name()) + "\"");
        if (type == 1 || type == 3) {
            start = 0L;
            end = fi.size() - 1L;
        }
        ctx.headerSet("Content-Length", Convert.toStr((Object)(end - start + 1L)));
        if (type == 1) {
            return 200;
        }
        long length = end - start + 1L;
        if (this.range) {
            ctx.headerSet("Content-Range", "bytes " + start + "-" + end + "/" + fi.size());
            resIn = this.fileSystem().fileInputStream(reqPath, start, length);
        } else {
            resIn = this.fileSystem().fileInputStream(reqPath, 0L, 0L);
        }
        try {
            ctx.output(resIn);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type == 2) {
            return 206;
        }
        return 0;
    }

    private int handleOptions(Context ctx) {
        String reqPath = this.stripPrefix(ctx.path());
        String allow = "OPTIONS, LOCK, PUT, MKCOL";
        FileInfo fi = this.fileSystem().fileInfo(reqPath);
        if (fi != null) {
            allow = fi.isDir() ? "OPTIONS, LOCK, DELETE, PROPPATCH, COPY, MOVE, UNLOCK, PROPFIND" : "OPTIONS, LOCK, GET, HEAD, POST, DELETE, PROPPATCH, COPY, MOVE, UNLOCK, PROPFIND, PUT";
        }
        ctx.headerSet("Allow", allow);
        ctx.headerSet("DAV", "1, 2");
        ctx.headerSet("MS-Author-Via", "DAV");
        return 0;
    }

    private String stripPrefix(String p) {
        int index = (p = URLUtil.decode((String)p)).indexOf(this.prefix());
        if (index == -1) {
            throw new WebDavActionException(404);
        }
        String r = p.substring(index + this.prefix().length());
        if (r.length() < p.length()) {
            if (r.endsWith("/")) {
                r = r.substring(0, r.length() - 1);
            }
            if (r.startsWith("/")) {
                r = r.substring(1);
            }
            return r;
        }
        throw new WebDavActionException(404);
    }
}

