/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.vertx;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.CookieImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.Cookie;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.handle.AsyncContextState;
import org.noear.solon.server.handle.ContextBase;
import org.noear.solon.server.util.DecodeUtils;
import org.noear.solon.server.util.RedirectUtils;
import org.noear.solon.web.vertx.RequestInputStream;
import org.noear.solon.web.vertx.ResponseOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VxWebContext
extends ContextBase {
    static final Logger log = LoggerFactory.getLogger(VxWebContext.class);
    private HttpServerRequest _request;
    private HttpServerResponse _response;
    private Buffer _requestBody;
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private String _url;
    private long contentLength = -2L;
    private InputStream bodyAsStream;
    private MultiMap<String> _paramMap;
    private MultiMap<String> _cookieMap;
    private MultiMap<String> _headerMap;
    private ResponseOutputStream responseOutputStream;
    private ByteArrayOutputStream _outputStreamTmp;
    private int _status = 200;
    private boolean _headers_sent = false;
    private boolean _allows_write = true;
    protected final AsyncContextState asyncState = new AsyncContextState();

    protected HttpServerRequest innerGetRequest() {
        return this._request;
    }

    protected HttpServerResponse innerGetResponse() {
        return this._response;
    }

    public VxWebContext(HttpServerRequest request, Buffer requestBody) {
        this._request = request;
        this._requestBody = requestBody;
        this._response = request.response();
    }

    private void loadMultipartFormData() {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData() && this._requestBody != null) {
            DecodeUtils.decodeMultipart((Context)this, (MultiMap)this._fileMap);
        }
    }

    public boolean isHeadersSent() {
        return this._headers_sent;
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        return this._request.remoteAddress().host();
    }

    public int remotePort() {
        return this._request.remoteAddress().port();
    }

    public String method() {
        return this._request.method().name();
    }

    public String protocol() {
        return "http";
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = this.parseURI(this.url());
        }
        return this._uri;
    }

    public boolean isSecure() {
        return false;
    }

    public String url() {
        if (this._url == null) {
            String tmp = this._request.absoluteURI();
            int idx = tmp.indexOf(63);
            this._url = idx < 0 ? tmp : tmp.substring(0, idx);
        }
        return this._url;
    }

    public long contentLength() {
        if (this.contentLength < -1L) {
            this.contentLength = DecodeUtils.decodeContentLengthLong((Context)this);
        }
        return this.contentLength;
    }

    public String queryString() {
        return this._request.query();
    }

    public InputStream bodyAsStream() throws IOException {
        if (this.bodyAsStream != null) {
            return this.bodyAsStream;
        }
        this.bodyAsStream = this._requestBody == null ? new ByteArrayInputStream(new byte[0]) : new RequestInputStream(this._requestBody.getByteBuf(), ServerProps.request_maxBodySize);
        return this.bodyAsStream;
    }

    public String body(String charset) throws IOException {
        try {
            return super.body(charset);
        }
        catch (Exception e) {
            throw DecodeUtils.status4xx((Context)this, (Exception)e);
        }
    }

    public MultiMap<String> paramMap() {
        this.paramsMapInit();
        return this._paramMap;
    }

    private void paramsMapInit() {
        if (this._paramMap == null) {
            this._paramMap = new MultiMap();
            try {
                DecodeUtils.decodeFormUrlencoded((Context)this, (boolean)false);
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (Map.Entry kv : this._request.params()) {
                    this._paramMap.add((String)kv.getKey(), kv.getValue());
                }
                for (Map.Entry kv : this._request.formAttributes()) {
                    this._paramMap.add((String)kv.getKey(), kv.getValue());
                }
            }
            catch (Exception e) {
                throw DecodeUtils.status4xx((Context)this, (Exception)e);
            }
        }
    }

    public MultiMap<UploadedFile> fileMap() {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
        }
        return this._fileMap;
    }

    public MultiMap<String> cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new MultiMap(false);
            DecodeUtils.decodeCookies((Context)this, (String)this.header("Cookie"));
        }
        return this._cookieMap;
    }

    public MultiMap<String> headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new MultiMap();
            for (Map.Entry kv : this._request.headers()) {
                this._headerMap.add((String)kv.getKey(), kv.getValue());
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType != null && contentType.length() > 0 && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    private ResponseOutputStream responseOutputStream() {
        if (this.responseOutputStream == null) {
            this.responseOutputStream = new ResponseOutputStream(this._response, 512);
        }
        return this.responseOutputStream;
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders(false);
        if (this._allows_write) {
            return this.responseOutputStream();
        }
        if (this._outputStreamTmp == null) {
            this._outputStreamTmp = new ByteArrayOutputStream();
        } else {
            this._outputStreamTmp.reset();
        }
        return this._outputStreamTmp;
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            IoUtil.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String name, String val) {
        this._response.headers().set(name, val);
    }

    public void headerAdd(String name, String val) {
        this._response.headers().add(name, val);
    }

    public String headerOfResponse(String name) {
        return this._response.headers().get(name);
    }

    public Collection<String> headerValuesOfResponse(String name) {
        return this._response.headers().getAll(name);
    }

    public Collection<String> headerNamesOfResponse() {
        return this._response.headers().names();
    }

    public void cookieSet(Cookie cookie) {
        CookieImpl c = new CookieImpl(cookie.name, cookie.value);
        if (cookie.maxAge >= 0) {
            c.setMaxAge((long)cookie.maxAge);
        }
        if (Utils.isNotEmpty((String)cookie.domain)) {
            c.setDomain(cookie.domain);
        }
        if (Utils.isNotEmpty((String)cookie.path)) {
            c.setPath(cookie.path);
        }
        c.setSecure(cookie.secure);
        c.setHttpOnly(cookie.httpOnly);
        this._response.addCookie((io.vertx.core.http.Cookie)c);
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._status;
    }

    protected void statusDoSet(int status) {
        this._status = status;
    }

    public void contentLength(long size) {
        if (!this._headers_sent) {
            this._response.putHeader("Content-Length", String.valueOf(size));
        }
    }

    public void flush() throws IOException {
        if (this._allows_write) {
            this.outputStream().flush();
        }
    }

    public void close() throws IOException {
        this._response.close();
    }

    protected void innerCommit() throws IOException {
        try {
            if (this.getHandled() || this.status() >= 200) {
                this.sendHeaders(true);
                this.flush();
                this._response.send();
            } else {
                this.status(404);
                this.sendHeaders(true);
                this.flush();
                this._response.send();
            }
        }
        finally {
            if (!this._response.ended()) {
                this._response.end();
            }
        }
    }

    private void sendHeaders(boolean isCommit) throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
            }
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
            this._response.setStatusCode(this.status());
            if (isCommit || !this._allows_write) {
                this._response.setChunked(true);
            } else if (!this._response.headers().contains("Content-Length")) {
                this._response.setChunked(true);
            }
        }
    }

    public boolean asyncSupported() {
        return true;
    }

    public boolean asyncStarted() {
        return this.asyncState.isStarted;
    }

    public void asyncListener(ContextAsyncListener listener) {
        this.asyncState.addListener(listener);
    }

    public void asyncStart(long timeout, Runnable runnable) {
        if (!this.asyncState.isStarted) {
            this.asyncState.isStarted = true;
            this.asyncState.asyncDelay(timeout, (Context)this, this::innerCommit);
            if (runnable != null) {
                runnable.run();
            }
            this.asyncState.onStart((Context)this);
        }
    }

    public void asyncComplete() {
        if (this.asyncState.isStarted) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
                this.asyncState.onError((Context)this, e);
            }
            finally {
                this.asyncState.onComplete((Context)this);
            }
        }
    }
}

