/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.vertx;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ResponseOutputStream
extends OutputStream {
    private ByteBuffer buf;
    private HttpServerResponse response;

    public ResponseOutputStream(HttpServerResponse response, int bufSize) {
        this.response = response;
        this.buf = ByteBuffer.allocate(bufSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.buf.put((byte)b);
        if (!this.buf.hasRemaining()) {
            byte[] bytes = new byte[this.buf.position()];
            this.buf.flip();
            this.buf.get(bytes);
            this.response.write((Object)Buffer.buffer((byte[])bytes));
            this.buf.clear();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.buf.position() > 0) {
            byte[] bytes = new byte[this.buf.position()];
            this.buf.flip();
            this.buf.get(bytes);
            this.response.write((Object)Buffer.buffer((byte[])bytes));
            this.buf.clear();
        }
    }
}

