/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.sdl.impl;

import java.io.Serializable;
import org.noear.redisx.RedisClient;
import org.noear.solon.Utils;
import org.noear.solon.web.sdl.SdlStorage;

public class SdlStorageOfRedis
implements SdlStorage {
    RedisClient storage;

    public SdlStorageOfRedis(RedisClient redisClient) {
        this.storage = redisClient;
    }

    @Override
    public String updateUserSdlKey(Serializable userId) {
        String storageKey = "user_sdl_key:" + userId;
        String userSdlKey = Utils.guid();
        this.storage.open(ru -> ru.key(storageKey).persist().set(userSdlKey));
        return userSdlKey;
    }

    @Override
    public void removeUserSdlKey(Serializable userId) {
        String storageKey = "user_sdl_key:" + userId;
        this.storage.open(ru -> ru.key(storageKey).delete());
    }

    @Override
    public String getUserSdlKey(Serializable userId) {
        String storageKey = "user_sdl_key:" + userId;
        return (String)this.storage.openAndGet(ru -> ru.key(storageKey).get());
    }
}

