/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.rx.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.Solon;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.rx.Completable;
import org.noear.solon.rx.handle.RxContext;
import org.noear.solon.rx.handle.RxFilter;
import org.noear.solon.rx.handle.RxFilterChainImpl;
import org.noear.solon.rx.handle.RxHandler;

public class RxChainManager {
    private final Set<Class<?>> typeSet = new HashSet();
    private final List<RankEntity<RxFilter>> filterNodes = new ArrayList<RankEntity<RxFilter>>();
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();

    public static RxChainManager getInstance() {
        return (RxChainManager)Solon.context().attachOf(RxChainManager.class, RxChainManager::new);
    }

    public Collection<RxFilter> getFilterNodes() {
        ArrayList<RxFilter> tmp = new ArrayList<RxFilter>();
        for (RankEntity<RxFilter> entity : this.filterNodes) {
            tmp.add((RxFilter)entity.target);
        }
        return tmp;
    }

    public void addFilter(RxFilter filter, int index) {
        this.SYNC_LOCK.lock();
        try {
            this.typeSet.add(filter.getClass());
            this.filterNodes.add((RankEntity<RxFilter>)new RankEntity((Object)filter, index));
            Collections.sort(this.filterNodes);
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void addFilterIfAbsent(RxFilter filter, int index) {
        this.SYNC_LOCK.lock();
        try {
            if (this.typeSet.contains(filter.getClass())) {
                return;
            }
            this.typeSet.add(filter.getClass());
            this.filterNodes.add((RankEntity<RxFilter>)new RankEntity((Object)filter, index));
            this.filterNodes.sort(Comparator.comparingInt(f -> f.index));
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public Completable doFilter(RxContext x, RxHandler lastHandler) throws Throwable {
        return new RxFilterChainImpl(this.filterNodes, lastHandler).doFilter(x);
    }
}

