/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.velocity;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.directive.Directive;
import org.noear.solon.Solon;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.web.DebugUtils;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.view.ViewConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityRender
implements Render {
    static final Logger log = LoggerFactory.getLogger(VelocityRender.class);
    private final ClassLoader classLoader;
    private final String viewPrefix;
    private Map<String, Object> sharedVariables = new HashMap<String, Object>();
    private RuntimeInstance provider;
    private RuntimeInstance providerOfDebug;

    public RuntimeInstance getProvider() {
        return this.provider;
    }

    public RuntimeInstance getProviderOfDebug() {
        return this.providerOfDebug;
    }

    public VelocityRender() {
        this((ClassLoader)AppClassLoader.global(), null);
    }

    public VelocityRender(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public VelocityRender(ClassLoader classLoader, String viewPrefix) {
        this.classLoader = classLoader;
        this.viewPrefix = viewPrefix == null ? ViewConfig.getViewPrefix() : viewPrefix;
        this.forDebug();
        this.forRelease();
        this.engineInit(this.provider);
        this.engineInit(this.providerOfDebug);
    }

    private void engineInit(RuntimeInstance ve) {
        if (ve == null) {
            return;
        }
        ve.setProperty("UTF-8", (Object)Solon.encoding());
        ve.setProperty("resource.default_encoding", (Object)Solon.encoding());
        Solon.cfg().forEach((k, v) -> {
            String key = k.toString();
            if (key.startsWith("velocity")) {
                ve.setProperty(key, v);
            }
        });
        ve.init();
    }

    private void forDebug() {
        if (!Solon.cfg().isDebugMode()) {
            return;
        }
        if (!Solon.cfg().isFilesMode()) {
            return;
        }
        if (ResourceUtil.hasFile((String)this.viewPrefix)) {
            return;
        }
        if (this.providerOfDebug != null) {
            return;
        }
        File dir = DebugUtils.getDebugLocation((ClassLoader)this.classLoader, (String)this.viewPrefix);
        if (dir == null) {
            return;
        }
        this.providerOfDebug = new RuntimeInstance();
        try {
            if (dir.exists()) {
                this.providerOfDebug.setProperty("resource.loader.file.path", (Object)(dir.getPath() + File.separatorChar));
            } else {
                this.forRelease();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void forRelease() {
        if (this.provider != null) {
            return;
        }
        this.provider = new RuntimeInstance();
        if (ResourceUtil.hasFile((String)this.viewPrefix)) {
            URL dir = ResourceUtil.findResource((ClassLoader)this.classLoader, (String)this.viewPrefix, (boolean)false);
            this.provider.setProperty("resource.loader.file.path", (Object)(dir.getFile() + File.separatorChar));
        } else {
            URL resource = ResourceUtil.getResource((ClassLoader)this.classLoader, (String)this.viewPrefix);
            if (resource == null) {
                return;
            }
            String root_path = resource.getPath();
            this.provider.setProperty("resource.loader.file.cache", (Object)true);
            this.provider.setProperty("resource.loader.file.path", (Object)root_path);
        }
    }

    public <T extends Directive> void putDirective(T obj) {
        this.provider.addDirective(obj);
        if (this.providerOfDebug != null) {
            this.providerOfDebug.addDirective(obj);
        }
    }

    public void putVariable(String key, Object obj) {
        this.sharedVariables.put(key, obj);
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    public void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=UTF-8");
        }
        if (ViewConfig.isOutputMeta()) {
            ctx.headerSet("Solon-View", "VelocityRender");
        }
        mv.putIfAbsent("context", (Object)ctx);
        String view = mv.view();
        Template template = null;
        if (this.providerOfDebug != null) {
            try {
                template = this.providerOfDebug.getTemplate(view, Solon.encoding());
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
        }
        if (template == null) {
            template = this.provider.getTemplate(view, Solon.encoding());
        }
        VelocityContext vc = new VelocityContext(mv.model());
        this.sharedVariables.forEach((k, v) -> vc.put(k, v));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream.get(), ServerProps.response_encoding));
        template.merge((org.apache.velocity.context.Context)vc, (Writer)writer);
        writer.flush();
    }
}

