/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.test;

import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.noear.solon.SimpleSolonApp;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.test.RunnerUtils;

public class SolonJUnit5Extension
implements TestInstanceFactory,
AfterAllCallback {
    private AppContext appContext;
    private Class<?> klass;

    public Object createTestInstance(TestInstanceFactoryContext factory, ExtensionContext extensionContext) throws TestInstantiationException {
        try {
            this.klass = factory.getTestClass();
            if (this.appContext == null) {
                this.appContext = RunnerUtils.initRunner(this.klass);
            }
            return RunnerUtils.initTestTarget(this.appContext, this.klass);
        }
        catch (Throwable e) {
            throw new TestInstantiationException("Test class instantiation failed: " + factory.getTestClass().getName(), e);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.afterAllDo();
    }

    protected void afterAllDo() {
        if (this.klass != null && Solon.app() != null && this.klass.equals(Solon.app().source()) && Solon.app() instanceof SimpleSolonApp) {
            ((SimpleSolonApp)Solon.app()).stop();
        }
    }
}

