/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.test;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.aspect.BeanProxy;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.event.AppInitEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.test.SolonTest;
import org.noear.solon.test.annotation.TestPropertySource;
import org.noear.solon.test.annotation.TestRollback;
import org.noear.solon.test.data.TestRollbackInterceptor;

public class SolonJUnit5Extension
implements TestInstanceFactory {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{SolonJUnit5Extension.class});
    private static final String TAG_classpath = "classpath:";
    private static Set<Class<?>> appCached = new HashSet();
    private Class<?> klassCached;

    public Object createTestInstance(TestInstanceFactoryContext factory, ExtensionContext extensionContext) throws TestInstantiationException {
        this.initDo(factory.getTestClass());
        Object tmp = null;
        try {
            tmp = Utils.newInstance((Class)factory.getTestClass());
        }
        catch (Exception e) {
            throw new TestInstantiationException("Test class instantiation failed: " + factory.getTestClass().getName());
        }
        Solon.context().beanInject(tmp);
        tmp = BeanProxy.getGlobal().getProxy(Solon.context(), tmp);
        return tmp;
    }

    private void initDo(Class<?> klass) {
        if (this.klassCached != null) {
            return;
        }
        this.klassCached = klass;
        SolonTest anno = klass.getAnnotation(SolonTest.class);
        TestPropertySource propAnno = klass.getAnnotation(TestPropertySource.class);
        EventBus.subscribe(AppInitEndEvent.class, e -> {
            this.addPropertySource(propAnno);
            Solon.context().beanAroundAdd(TestRollback.class, (Interceptor)new TestRollbackInterceptor(), 120);
        });
        if (anno != null) {
            if (anno.properties().length > 0) {
                for (String tmp : anno.properties()) {
                    String[] kv = tmp.split("=");
                    if (kv.length != 2) continue;
                    System.setProperty(kv[0], kv[1]);
                }
            }
            ArrayList<String> args = new ArrayList<String>();
            if (anno.args().length > 0) {
                args.addAll(Arrays.asList(anno.args()));
            }
            if (anno.debug()) {
                args.add("-debug=1");
            }
            String[] argsStr = args.toArray(new String[args.size()]);
            if (appCached.contains(anno.getClass())) {
                return;
            }
            appCached.add(anno.getClass());
            try {
                Method main = this.getMain(anno);
                if (main != null && Modifier.isStatic(main.getModifiers())) {
                    main.invoke(null, new Object[]{argsStr});
                } else {
                    Solon.start(anno.value(), (String[])argsStr);
                }
            }
            catch (Throwable ex) {
                Utils.throwableUnwrap((Throwable)ex).printStackTrace();
            }
            if (anno.delay() > 0) {
                try {
                    Thread.sleep(anno.delay() * 1000);
                }
                catch (Exception exception) {}
            }
        } else {
            Solon.start(klass, (String[])new String[]{"-debug=1"});
        }
    }

    private void addPropertySource(TestPropertySource propertySource) {
        if (propertySource == null) {
            return;
        }
        for (String uri : propertySource.value()) {
            if (uri.startsWith(TAG_classpath)) {
                Solon.cfg().loadAdd(uri.substring(TAG_classpath.length()));
                continue;
            }
            try {
                Solon.cfg().loadAdd(new File(uri).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Method getMain(SolonTest anno) {
        try {
            return anno.value().getMethod("main", String[].class);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

