/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.jwt;

import org.noear.solon.Solon;
import org.noear.solon.annotation.BindProps;

@BindProps(prefix="server.session.state.jwt")
public class JwtSessionProps {
    private static JwtSessionProps instance;
    public final String name = Solon.cfg().get("server.session.state.jwt.name", "TOKEN");
    public final String secret = Solon.cfg().get("server.session.state.jwt.secret");
    public final String prefix = Solon.cfg().get("server.session.state.jwt.prefix", "").trim();
    public final boolean allowExpire = Solon.cfg().getBool("server.session.state.jwt.allowExpire", true);
    public final boolean allowAutoIssue;
    public final boolean allowUseHeader;

    public static JwtSessionProps getInstance() {
        if (instance == null) {
            instance = new JwtSessionProps();
        }
        return instance;
    }

    private JwtSessionProps() {
        boolean issueOld = Solon.cfg().getBool("server.session.state.jwt.allowIssue", true);
        boolean issueNew = Solon.cfg().getBool("server.session.state.jwt.allowAutoIssue", true);
        this.allowAutoIssue = issueOld && issueNew;
        boolean allowUseHeaderTmp = Solon.cfg().getBool("server.session.state.jwt.allowUseHeader", false);
        boolean requestUseHeader = Solon.cfg().getBool("server.session.state.jwt.requestUseHeader", false);
        boolean responseUseHeader = Solon.cfg().getBool("server.session.state.jwt.responseUseHeader", false);
        if (requestUseHeader || responseUseHeader) {
            allowUseHeaderTmp = true;
        }
        this.allowUseHeader = allowUseHeaderTmp;
    }
}

