/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.jedis;

import java.io.IOException;
import java.util.Collection;
import org.noear.redisx.RedisClient;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.serialize.Serializer;
import org.noear.solon.server.handle.SessionStateBase;
import org.noear.solon.sessionstate.jedis.JavabinSerializer;
import org.noear.solon.sessionstate.jedis.JedisSessionStateFactory;

public class JedisSessionState
extends SessionStateBase {
    private RedisClient redisClient;
    private Serializer<String> serializer = JavabinSerializer.instance;
    private String sessionId;

    protected JedisSessionState(Context ctx) {
        super(ctx);
        this.redisClient = JedisSessionStateFactory.getInstance().redisClient();
    }

    public boolean replaceable() {
        return false;
    }

    public long creationTime() {
        return this.ctx.sessionAsLong("SESSION_CREATION_TIME", 0L);
    }

    public long lastAccessTime() {
        return this.ctx.sessionAsLong("SESSION_LAST_ACCESS_TIME", 0L);
    }

    public String sessionId() {
        if (this.sessionId == null) {
            this.sessionId = this.sessionIdGet(false);
        }
        return this.sessionId;
    }

    public String sessionChangeId() {
        this.sessionId = this.sessionIdGet(true);
        return this.sessionId;
    }

    public Collection<String> sessionKeys() {
        return (Collection)this.redisClient.openAndGet(ru -> ru.key(this.sessionId()).hashGetAllKeys());
    }

    public <T> T sessionGet(String key, Class<T> clz) {
        String val = (String)this.redisClient.openAndGet(ru -> ru.key(this.sessionId()).expire(_expiry).hashGet(key));
        if (val == null) {
            return null;
        }
        try {
            return (T)this.serializer.deserialize((Object)val, clz);
        }
        catch (Exception e) {
            throw new RuntimeException("Session state deserialization error: " + key + " = " + val, e);
        }
    }

    public void sessionSet(String key, Object val) {
        if (val == null) {
            this.sessionRemove(key);
        } else {
            try {
                String json = (String)this.serializer.serialize(val);
                this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).hashSet(key, json));
            }
            catch (Exception e) {
                throw new RuntimeException("Session state serialization error: " + key + " = " + val, e);
            }
        }
    }

    public void sessionRemove(String key) {
        this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).hashDel(new String[]{key}));
    }

    public void sessionClear() {
        this.redisClient.open(ru -> ru.key(this.sessionId()).delete());
    }

    public void sessionReset() {
        this.sessionClear();
        this.sessionChangeId();
    }

    public void sessionRefresh() throws IOException {
        String sid = this.sessionIdPush();
        if (!Utils.isEmpty((String)sid)) {
            long now = System.currentTimeMillis();
            String json = (String)this.serializer.serialize((Object)now);
            this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).hashInit("SESSION_CREATION_TIME", json));
        }
    }

    public void sessionPublish() throws IOException {
        String sid = this.sessionId();
        if (!Utils.isEmpty((String)sid)) {
            long now = System.currentTimeMillis();
            String json = (String)this.serializer.serialize((Object)now);
            this.redisClient.open(ru -> ru.key(this.sessionId()).expire(_expiry).hashSet("SESSION_LAST_ACCESS_TIME", json));
        }
    }
}

