/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.server.prop.ServerSslProps;

public class SslContextBuilder {
    private String protocol = "TLS";
    private String algorithm = "SunX509";
    private SecureRandom secureRandom = null;
    private KeyManager[] keyManagers = null;
    private TrustManager[] trustManagers = null;
    private String keyType = "JKS";
    private String trustType = null;

    public SslContextBuilder props(ServerSslProps props) {
        String sslKeyStoreType = props.getSslKeyStoreType();
        String sslKeyStore = props.getSslKeyStore();
        String sslKeyStorePassword = props.getSslKeyStorePassword();
        String sslTrustStoreType = props.getSslTrustStoreType();
        String sslTrustStore = props.getSslTrustStore();
        String sslTrustStorePassword = props.getSslTrustStorePassword();
        if (Utils.isNotEmpty((String)sslKeyStoreType)) {
            this.keyType(sslKeyStoreType);
        }
        if (Utils.isNotEmpty((String)sslTrustStoreType)) {
            this.trustType(sslTrustStoreType);
        }
        try {
            URL tmp;
            if (Utils.isNotEmpty((String)sslKeyStore) && (tmp = ResourceUtil.findResource((String)sslKeyStore)) != null) {
                this.keyManager(tmp, sslKeyStorePassword, sslKeyStorePassword);
            }
            if (Utils.isNotEmpty((String)sslTrustStore) && (tmp = ResourceUtil.findResource((String)sslTrustStore)) != null) {
                this.trustManager(tmp, sslTrustStorePassword);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public SslContextBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public SslContextBuilder algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public SslContextBuilder secureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public SslContextBuilder keyType(String keyStoreType) {
        this.keyType = keyStoreType;
        return this;
    }

    public SslContextBuilder trustType(String trustStoreType) {
        this.trustType = trustStoreType;
        return this;
    }

    public SslContextBuilder keyManager(String keyStoreFile, String keyStorePassword, String keyPassword) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        try (FileInputStream inputStream = new FileInputStream(keyStoreFile);){
            SslContextBuilder sslContextBuilder = this.keyManager(inputStream, keyStorePassword, keyPassword);
            return sslContextBuilder;
        }
    }

    public SslContextBuilder keyManager(URL keyStoreUrl, String keyStorePassword, String keyPassword) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        try (InputStream inputStream = keyStoreUrl.openStream();){
            SslContextBuilder sslContextBuilder = this.keyManager(inputStream, keyStorePassword, keyPassword);
            return sslContextBuilder;
        }
    }

    public SslContextBuilder keyManager(InputStream keyStoreInputStream, String keyStorePassword, String keyPassword) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        KeyStore ks = this.loadKeyStore(this.keyType, keyStoreInputStream, keyStorePassword.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.algorithm);
        kmf.init(ks, keyPassword.toCharArray());
        this.keyManagers = kmf.getKeyManagers();
        return this;
    }

    public SslContextBuilder trustManager(String trustStoreFile, String trustStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (FileInputStream inputStream = new FileInputStream(trustStoreFile);){
            SslContextBuilder sslContextBuilder = this.trustManager(inputStream, trustStorePassword);
            return sslContextBuilder;
        }
    }

    public SslContextBuilder trustManager(URL trustStoreUrl, String trustStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream inputStream = trustStoreUrl.openStream();){
            SslContextBuilder sslContextBuilder = this.trustManager(inputStream, trustStorePassword);
            return sslContextBuilder;
        }
    }

    public SslContextBuilder trustManager(InputStream trustStoreInputStream, String trustStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        String type = this.trustType == null ? this.keyType : this.trustType;
        KeyStore ts = this.loadKeyStore(type, trustStoreInputStream, trustStorePassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(this.algorithm);
        tmf.init(ts);
        this.trustManagers = tmf.getTrustManagers();
        return this;
    }

    public SslContextBuilder trustManagerAsEmpty() {
        this.trustManagers = new TrustManager[]{new EmptyX509TrustManager()};
        return this;
    }

    public SSLContext build() {
        try {
            SSLContext sslContext = SSLContext.getInstance(this.protocol);
            sslContext.init(this.keyManagers, this.trustManagers, this.secureRandom);
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private KeyStore loadKeyStore(String type, InputStream keyStoreInputStream, char[] password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        KeyStore ks = KeyStore.getInstance(type);
        ks.load(keyStoreInputStream, password);
        return ks;
    }

    private static final class EmptyX509TrustManager
    implements X509TrustManager {
        private final X509Certificate[] acceptedIssuers = new X509Certificate[0];

        private EmptyX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.acceptedIssuers;
        }
    }
}

