/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.http.uploadfile;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.noear.solon.server.http.uploadfile.Helper;
import org.noear.solon.server.http.uploadfile.HttpMultipart;
import org.noear.solon.server.http.uploadfile.HttpMultipartInputStream;

public class HttpMultipartCollection
implements Iterator<HttpMultipart> {
    protected final HttpMultipartInputStream in;
    protected boolean next;

    public HttpMultipartCollection(String contextType, InputStream bodyStream) throws IOException {
        Map<String, String> ct = Helper.getHeaderParams(contextType);
        if (!ct.containsKey("multipart/form-data")) {
            throw new IllegalArgumentException("Content-Type is not multipart/form-data");
        }
        String boundary = ct.get("boundary");
        if (boundary == null) {
            throw new IllegalArgumentException("Content-Type is missing boundary");
        }
        this.in = new HttpMultipartInputStream(bodyStream, Helper.getBytes(boundary));
    }

    @Override
    public boolean hasNext() {
        try {
            return this.next || (this.next = this.in.nextPart());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public HttpMultipart next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.next = false;
        HttpMultipart p = new HttpMultipart();
        try {
            p.headers = Helper.readHeaders(this.in);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Map<String, String> cd = p.headers.getParams("Content-Disposition");
        p.name = cd.get("name");
        p.filename = cd.get("filename");
        p.body = this.in;
        return p;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

