/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.util;

import java.io.File;
import java.net.URL;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;

public class DebugUtils {
    public static boolean isTestLocation(URL url) {
        return url.getPath().contains("/target/test-classes/") || url.getPath().contains("/build/classes/test/");
    }

    public static File getDebugLocation(ClassLoader classLoader, String pathPrefix) {
        if (Utils.isEmpty((String)pathPrefix)) {
            return null;
        }
        if (ResourceUtil.hasFile((String)pathPrefix)) {
            return null;
        }
        URL sourceLocation = null;
        sourceLocation = Solon.app() == null ? ResourceUtil.getResource((ClassLoader)classLoader, (String)"/") : Solon.app().sourceLocation();
        if (sourceLocation == null) {
            return null;
        }
        String userdir = System.getProperty("user.dir");
        File dir = null;
        if (pathPrefix.charAt(0) != '/') {
            pathPrefix = "/" + pathPrefix;
        }
        if (DebugUtils.isTestLocation(sourceLocation)) {
            String dir_str = userdir + "/src/test/resources" + pathPrefix;
            dir = new File(dir_str);
            if (!dir.exists()) {
                dir_str = userdir + "/src/test/webapp" + pathPrefix;
                dir = new File(dir_str);
            }
            if (!dir.exists()) {
                return null;
            }
        } else {
            String dir_str = userdir + "/src/main/resources" + pathPrefix;
            dir = new File(dir_str);
            if (!dir.exists()) {
                dir_str = userdir + "/src/main/webapp" + pathPrefix;
                dir = new File(dir_str);
            }
            if (!dir.exists()) {
                return null;
            }
        }
        return dir;
    }
}

