/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.websocket.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;
import org.noear.solon.server.util.DecodeUtils;
import org.noear.solon.server.websocket.netty.NettyWsServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketImpl
extends WebSocketTimeoutBase {
    private static final Logger log = LoggerFactory.getLogger(WebSocketImpl.class);
    private ChannelHandlerContext real;

    public WebSocketImpl(ChannelHandlerContext real) {
        this.real = real;
        String uri = DecodeUtils.rinseUri((String)((String)real.attr(NettyWsServerHandler.ResourceDescriptorKey).get()));
        this.init(URI.create(uri));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.channel().isOpen();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.real.channel().remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.real.channel().localAddress();
    }

    public Future<Void> send(String text) {
        try {
            ChannelFuture channelFuture = this.real.writeAndFlush((Object)new TextWebSocketFrame(text));
            return channelFuture;
        }
        finally {
            this.onSend();
        }
    }

    public Future<Void> send(ByteBuffer binary) {
        try {
            ChannelFuture channelFuture = this.real.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)binary)));
            return channelFuture;
        }
        finally {
            this.onSend();
        }
    }

    public void close() {
        super.close();
        if (this.real.channel().isActive()) {
            this.real.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess() && log.isDebugEnabled()) {
                    log.debug("Close failure: {}", (Object)future.cause().getMessage());
                }
            }));
        }
    }

    public void close(int code, String reason) {
        super.close(code, reason);
        if (this.real.channel().isActive()) {
            CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(code, reason);
            this.real.channel().writeAndFlush((Object)closeFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess() && log.isDebugEnabled()) {
                    log.debug("Close failure: {}", (Object)future.cause().getMessage());
                }
            }));
        }
    }
}

