/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.vertx.websocket;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.noear.solon.Utils;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;
import org.noear.solon.server.util.DecodeUtils;
import org.noear.solon.server.vertx.websocket.CallbackFuture;

public class VxWebSocketImpl
extends WebSocketTimeoutBase {
    private ServerWebSocket real;
    private InetSocketAddress remoteAddress;
    private InetSocketAddress localAddress;

    public VxWebSocketImpl(ServerWebSocket real) {
        this.real = real;
        String uri = this.buildUri(real);
        this.init(URI.create(uri));
    }

    public String buildUri(ServerWebSocket req) {
        if (Utils.isEmpty((String)req.query())) {
            return DecodeUtils.rinseUri((String)req.uri());
        }
        if (req.uri().contains("?")) {
            return DecodeUtils.rinseUri((String)req.uri());
        }
        return DecodeUtils.rinseUri((String)req.uri()) + "?" + req.query();
    }

    private static InetSocketAddress toInetSocketAddress(SocketAddress socketAddress) {
        return new InetSocketAddress(socketAddress.hostAddress(), socketAddress.port());
    }

    public boolean isValid() {
        return !this.isClosed();
    }

    public boolean isSecure() {
        return this.real.isSsl();
    }

    public InetSocketAddress remoteAddress() {
        if (this.remoteAddress == null) {
            this.remoteAddress = VxWebSocketImpl.toInetSocketAddress(this.real.remoteAddress());
        }
        return this.remoteAddress;
    }

    public InetSocketAddress localAddress() {
        if (this.localAddress == null) {
            this.localAddress = VxWebSocketImpl.toInetSocketAddress(this.real.localAddress());
        }
        return this.localAddress;
    }

    public Future<Void> send(String text) {
        CallbackFuture future = new CallbackFuture();
        this.real.writeFinalTextFrame(text, (Handler)future);
        this.onSend();
        return future;
    }

    public Future<Void> send(ByteBuffer binary) {
        CallbackFuture future = new CallbackFuture();
        this.real.writeBinaryMessage(Buffer.buffer((byte[])binary.array()), (Handler)future);
        this.onSend();
        return future;
    }

    public void close() {
        super.close();
        if (!this.real.isClosed()) {
            RunUtil.runAndTry(() -> ((ServerWebSocket)this.real).close());
        }
    }
}

