/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.undertow;

import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.util.DefaultClassIntrospector;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.servlet.MultipartConfigElement;
import org.noear.solon.Solon;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.lang.Nullable;
import org.noear.solon.server.ServerLifecycle;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.handle.SessionProps;
import org.noear.solon.server.http.HttpServerConfigure;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.ssl.SslConfig;
import org.noear.solon.server.undertow.http.UtContainerInitializer;
import org.noear.solon.server.undertow.integration.UndertowPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class UndertowServerBase
implements ServerLifecycle,
HttpServerConfigure {
    static final Logger log = LoggerFactory.getLogger(UndertowServerBase.class);
    protected final HttpServerProps props;
    protected SslConfig sslConfig = new SslConfig("http");
    protected Set<Integer> addHttpPorts = new LinkedHashSet<Integer>();
    protected boolean enableHttp2 = false;

    public UndertowServerBase(HttpServerProps props) {
        this.props = props;
    }

    public void enableSsl(boolean enable, @Nullable SSLContext sslContext) {
        this.sslConfig.set(enable, sslContext);
    }

    public boolean isSupportedHttp2() {
        return true;
    }

    public void enableHttp2(boolean enable) {
        this.enableHttp2 = enable;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public void addHttpPort(int port) {
        this.addHttpPorts.add(port);
    }

    public void setExecutor(Executor executor) {
        log.warn("Undertow does not support user-defined executor");
    }

    public HttpServerProps getProps() {
        return this.props;
    }

    protected DeploymentInfo initDeploymentInfo() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File scratchDir = new File(tempDir, "solon-server");
        if (!scratchDir.exists()) {
            scratchDir.mkdirs();
        }
        String _tempdir = scratchDir.getAbsolutePath();
        int _fileOutputBuffer = 0;
        long _maxBodySize = ServerProps.request_maxBodySize > 0L ? ServerProps.request_maxBodySize : -1L;
        long _maxFileSize = ServerProps.request_maxFileSize > 0L ? ServerProps.request_maxFileSize : -1L;
        MultipartConfigElement multipartConfig = new MultipartConfigElement(_tempdir, _maxFileSize, _maxBodySize, _fileOutputBuffer);
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(UndertowPlugin.class.getClassLoader()).setDeploymentName("solon").setContextPath("/").setDefaultEncoding(ServerProps.request_encoding).setDefaultMultipartConfig(multipartConfig).setClassIntrospecter((ClassIntrospecter)DefaultClassIntrospector.INSTANCE);
        builder.addServletContainerInitializer(UtContainerInitializer.info());
        builder.setEagerFilterInit(true);
        if (SessionProps.session_timeout > 0) {
            builder.setDefaultSessionTimeout(SessionProps.session_timeout);
        }
        return builder;
    }

    protected String getResourceRoot() throws FileNotFoundException {
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            if (NativeDetector.inNativeImage()) {
                return "";
            }
            throw new FileNotFoundException("Unable to find root");
        }
        String resURL = rootURL.toString();
        if (Solon.cfg().isDebugMode() && !resURL.startsWith("jar:")) {
            int endIndex = resURL.indexOf("target");
            return resURL.substring(0, endIndex) + "src/main/resources/";
        }
        return "";
    }

    protected URL getRootPath() {
        URL root = ResourceUtil.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            URL temp = ResourceUtil.getResource((String)"");
            if (temp == null) {
                return null;
            }
            String path = temp.toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

