/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.undertow.websocket;

import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.net.URI;
import java.util.Collection;
import org.noear.solon.Utils;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.noear.solon.server.undertow.websocket.UtWsChannelListener;
import org.noear.solon.server.util.DecodeUtils;
import org.xnio.ChannelListener;

public class UtWsConnectionCallback
implements WebSocketConnectionCallback {
    private final UtWsChannelListener listener = new UtWsChannelListener();
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void onHandshake(WebSocketHttpExchange exchange) {
        String protocols;
        String uri = DecodeUtils.rinseUri((String)exchange.getRequestURI());
        String path = URI.create(uri).getPath();
        SubProtocolCapable subProtocolCapable = this.webSocketRouter.getSubProtocol(path);
        if (subProtocolCapable != null && Utils.isNotEmpty((String)(protocols = subProtocolCapable.getSubProtocols((Collection)exchange.getRequestHeaders().get("Sec-WebSocket-Protocol"))))) {
            exchange.setResponseHeader("Sec-WebSocket-Protocol", protocols);
        }
    }

    public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        this.listener.onOpen(exchange, channel);
        channel.getReceiveSetter().set((ChannelListener)this.listener);
        channel.resumeReceives();
    }
}

