/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.undertow.websocket;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.util.Methods;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.spi.AsyncWebSocketHttpServerExchange;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.server.undertow.websocket.UtWsConnectionCallback;
import org.xnio.StreamConnection;

public class UtWsProtocolHandshakeHandler
implements HttpHandler {
    private final Set<Handshake> handshakes;
    private final HttpUpgradeListener upgradeListener;
    private final UtWsConnectionCallback callback;
    private final Set<WebSocketChannel> peerConnections = Collections.newSetFromMap(new ConcurrentHashMap());
    private final HttpHandler next;

    public UtWsProtocolHandshakeHandler(HttpHandler next) {
        this.callback = new UtWsConnectionCallback();
        HashSet<Handshake> handshakes = new HashSet<Handshake>();
        handshakes.add((Handshake)new Hybi13Handshake());
        handshakes.add((Handshake)new Hybi08Handshake());
        handshakes.add((Handshake)new Hybi07Handshake());
        this.handshakes = handshakes;
        this.next = next;
        this.upgradeListener = null;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (!exchange.getRequestMethod().equals(Methods.GET)) {
            this.next.handleRequest(exchange);
        } else {
            final AsyncWebSocketHttpServerExchange facade = new AsyncWebSocketHttpServerExchange(exchange, this.peerConnections);
            Handshake handshaker = null;
            for (Handshake method : this.handshakes) {
                if (!method.matches((WebSocketHttpExchange)facade)) continue;
                handshaker = method;
                break;
            }
            if (handshaker == null) {
                this.next.handleRequest(exchange);
            } else {
                WebSocketLogger.REQUEST_LOGGER.debugf("Attempting websocket handshake with %s on %s", handshaker, (Object)exchange);
                final Handshake selected = handshaker;
                if (this.upgradeListener == null) {
                    exchange.upgradeChannel(new HttpUpgradeListener(){

                        public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                            WebSocketChannel channel = selected.createChannel((WebSocketHttpExchange)facade, streamConnection, facade.getBufferPool());
                            UtWsProtocolHandshakeHandler.this.peerConnections.add(channel);
                            UtWsProtocolHandshakeHandler.this.callback.onConnect((WebSocketHttpExchange)facade, channel);
                        }
                    });
                } else {
                    exchange.upgradeChannel(this.upgradeListener);
                }
                this.callback.onHandshake((WebSocketHttpExchange)facade);
                handshaker.handshake((WebSocketHttpExchange)facade);
            }
        }
    }

    public Set<WebSocketChannel> getPeerConnections() {
        return this.peerConnections;
    }

    public UtWsProtocolHandshakeHandler addExtension(ExtensionHandshake extension) {
        if (extension != null) {
            for (Handshake handshake : this.handshakes) {
                handshake.addExtension(extension);
            }
        }
        return this;
    }
}

