/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat.websocket;

import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.noear.solon.server.tomcat.websocket.WebSocketImpl;

public class TcWebSocketEndpoint
extends Endpoint {
    private final String SESSION_KEY = "session";
    private static final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        session.setMaxTextMessageBufferSize(17000000);
        session.setMaxBinaryMessageBufferSize(17000000);
        WebSocketImpl socket = new WebSocketImpl(session);
        session.getUserProperties().put("session", socket);
        session.addMessageHandler((MessageHandler)new BufferMessageHandler((WebSocket)socket));
        session.addMessageHandler((MessageHandler)new TextMessageHandler((WebSocket)socket));
        webSocketRouter.getListener().onOpen((WebSocket)socket);
    }

    public void onClose(Session session, CloseReason closeReason) {
        WebSocket socket = (WebSocket)session.getUserProperties().get("session");
        if (socket != null) {
            webSocketRouter.getListener().onClose(socket);
        }
    }

    public void onError(Session session, Throwable thr) {
        WebSocket socket = (WebSocket)session.getUserProperties().get("session");
        if (socket != null) {
            webSocketRouter.getListener().onError(socket, thr);
        }
    }

    private static class BufferMessageHandler
    implements MessageHandler.Whole<ByteBuffer> {
        private final WebSocket socket;

        public BufferMessageHandler(WebSocket socket) {
            this.socket = socket;
        }

        public void onMessage(ByteBuffer buffer) {
            try {
                webSocketRouter.getListener().onMessage(this.socket, buffer);
            }
            catch (Throwable e) {
                webSocketRouter.getListener().onError(this.socket, e);
            }
        }
    }

    private static class TextMessageHandler
    implements MessageHandler.Whole<String> {
        private final WebSocket socket;

        public TextMessageHandler(WebSocket socket) {
            this.socket = socket;
        }

        public void onMessage(String text) {
            try {
                webSocketRouter.getListener().onMessage(this.socket, text);
            }
            catch (Throwable e) {
                webSocketRouter.getListener().onError(this.socket, e);
            }
        }
    }
}

