/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat.websocket;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketBase;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcWebSocketEndpoint
extends Endpoint {
    private final String SESSION_KEY = "session";
    private static final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        WebSocketImpl socket = new WebSocketImpl(session);
        session.getUserProperties().put("session", socket);
        session.addMessageHandler((MessageHandler)new BufferMessageHandler((WebSocket)socket));
        session.addMessageHandler((MessageHandler)new TextMessageHandler((WebSocket)socket));
        webSocketRouter.getListener().onOpen((WebSocket)socket);
    }

    public void onClose(Session session, CloseReason closeReason) {
        WebSocket socket = (WebSocket)session.getUserProperties().get("session");
        if (socket != null) {
            webSocketRouter.getListener().onClose(socket);
        }
    }

    public void onError(Session session, Throwable thr) {
        WebSocket socket = (WebSocket)session.getUserProperties().get("session");
        if (socket != null) {
            webSocketRouter.getListener().onError(socket, thr);
        }
    }

    private static class WebSocketImpl
    extends WebSocketBase {
        private static final Logger log = LoggerFactory.getLogger(WebSocketImpl.class);
        private Session real;

        public WebSocketImpl(Session real) {
            this.real = real;
            this.init(real.getRequestURI());
        }

        public boolean isValid() {
            return !this.isClosed() && this.real.isOpen();
        }

        public boolean isSecure() {
            return this.real.isSecure();
        }

        public InetSocketAddress remoteAddress() {
            return null;
        }

        public InetSocketAddress localAddress() {
            return null;
        }

        public long getIdleTimeout() {
            return this.real.getMaxIdleTimeout();
        }

        public void setIdleTimeout(long idleTimeout) {
            this.real.setMaxIdleTimeout(idleTimeout);
        }

        public Future<Void> send(String text) {
            return this.real.getAsyncRemote().sendText(text);
        }

        public Future<Void> send(ByteBuffer binary) {
            return this.real.getAsyncRemote().sendBinary(binary);
        }

        public void close() {
            block2: {
                super.close();
                try {
                    this.real.close();
                }
                catch (Throwable ignore) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("Close failure: {}", (Object)ignore.getMessage());
                }
            }
        }

        public void close(int code, String reason) {
            block2: {
                super.close(code, reason);
                try {
                    this.real.close(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), reason));
                }
                catch (Throwable ignore) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("Close failure: {}", (Object)ignore.getMessage());
                }
            }
        }
    }

    private static class BufferMessageHandler
    implements MessageHandler.Whole<ByteBuffer> {
        private WebSocket socket;

        public BufferMessageHandler(WebSocket socket) {
            this.socket = socket;
        }

        public void onMessage(ByteBuffer s) {
            try {
                webSocketRouter.getListener().onMessage(this.socket, s);
            }
            catch (Throwable e) {
                webSocketRouter.getListener().onError(this.socket, e);
            }
        }
    }

    private static class TextMessageHandler
    implements MessageHandler.Whole<String> {
        private WebSocket socket;

        public TextMessageHandler(WebSocket socket) {
            this.socket = socket;
        }

        public void onMessage(String s) {
            try {
                webSocketRouter.getListener().onMessage(this.socket, s);
            }
            catch (Throwable e) {
                webSocketRouter.getListener().onError(this.socket, e);
            }
        }
    }
}

