/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.tomcat;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.handle.SessionProps;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.tomcat.TomcatServerBase;
import org.noear.solon.server.tomcat.http.TCHttpContextHandler;
import org.noear.solon.server.tomcat.ssl.TomcatSslContext;

public class TomcatServer
extends TomcatServerBase {
    protected boolean isSecure;
    protected boolean enableWebSocket;

    public boolean isSecure() {
        return this.isSecure;
    }

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public TomcatServer(HttpServerProps props) {
        super(props);
    }

    @Override
    protected Context initContext() {
        String _tempdir = IoUtil.getTempDirAsString((String)"solon-server");
        this._server.setBaseDir(_tempdir);
        Context context = this._server.addContext("/", null);
        context.setAllowCasualMultipartParsing(true);
        if (SessionProps.session_timeout > 0) {
            context.setSessionTimeout(SessionProps.session_timeout);
        }
        MultipartConfigElement multipartConfig = new MultipartConfigElement(_tempdir, ServerProps.request_maxFileSize, ServerProps.request_maxFileRequestSize(), ServerProps.request_fileSizeThreshold);
        Wrapper servlet = Tomcat.addServlet((Context)context, (String)"solon", (Servlet)new TCHttpContextHandler());
        servlet.setAsyncSupported(true);
        servlet.setMultipartConfigElement(multipartConfig);
        context.addServletMappingDecoded("/", "solon");
        return context;
    }

    @Override
    protected void addConnector(int port, boolean isMain) throws IOException {
        ProtocolHandler protocol = this.createHttp11Protocol(isMain);
        if (isMain && this.enableHttp2) {
            protocol.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
        Connector connector = new Connector(protocol);
        connector.setPort(port);
        if (isMain && this.sslConfig.isSslEnable()) {
            connector.setSecure(true);
            connector.setScheme("https");
        }
        connector.setMaxPostSize(ServerProps.request_maxBodySizeAsInt());
        connector.setMaxPartHeaderSize(ServerProps.request_maxHeaderSize);
        connector.setURIEncoding(ServerProps.request_encoding);
        connector.setUseBodyEncodingForURI(true);
        this._server.getService().addConnector(connector);
    }

    private ProtocolHandler createHttp11Protocol(boolean isMain) throws IOException {
        Http11NioProtocol protocol = new Http11NioProtocol();
        if (ServerProps.request_maxHeaderSize > 0) {
            protocol.setMaxHttpHeaderSize(ServerProps.request_maxHeaderSize);
        }
        if (ServerProps.request_maxBodySize > 0L) {
            protocol.setMaxSwallowSize(ServerProps.request_maxBodySizeAsInt());
        }
        protocol.setRelaxedQueryChars("[]|{}");
        if (isMain && this.sslConfig.isSslEnable()) {
            protocol.setSSLEnabled(true);
            protocol.setSecure(true);
            protocol.addSslHostConfig(TomcatServer.createSSLHostConfig(this.sslConfig.getSslContext()));
            this.isSecure = true;
        }
        return protocol;
    }

    private static SSLHostConfig createSSLHostConfig(SSLContext sslContext) {
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        SSLHostConfigCertificate sslHostConfigCertificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.RSA);
        sslHostConfigCertificate.setSslContext((org.apache.tomcat.util.net.SSLContext)new TomcatSslContext(sslContext));
        sslHostConfig.addCertificate(sslHostConfigCertificate);
        return sslHostConfig;
    }
}

