/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.smarthttp;

import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.lang.Nullable;
import org.noear.solon.server.ServerLifecycle;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.prop.impl.WebSocketServerProps;
import org.noear.solon.server.smarthttp.http.SmHttpContextHandler;
import org.noear.solon.server.smarthttp.websocket.SmWebSocketHandleImpl;
import org.noear.solon.server.ssl.SslConfig;
import org.smartboot.http.server.HttpBootstrap;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.extension.ssl.factory.SSLContextFactory;

public class SmHttpServer
implements ServerLifecycle {
    protected final HttpServerProps props;
    protected HttpBootstrap server = null;
    protected Handler handler;
    protected int coreThreads;
    protected Executor workExecutor;
    protected boolean enableWebSocket;
    protected SslConfig sslConfig = new SslConfig("http");
    protected boolean enableDebug = false;
    protected boolean isSecure;

    public SmHttpServer(HttpServerProps props) {
        this.props = props;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void enableSsl(boolean enable, @Nullable SSLContext sslContext) {
        this.sslConfig.set(enable, sslContext);
    }

    public void enableDebug(boolean enable) {
        this.enableDebug = enable;
    }

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void setWorkExecutor(Executor executor) {
        this.workExecutor = executor;
    }

    public void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
    }

    public void start(String host, int port) throws Throwable {
        WebSocketServerProps wsProps;
        this.server = new HttpBootstrap();
        HttpServerConfiguration _config = this.server.configuration();
        if (Utils.isNotEmpty((String)host)) {
            _config.host(host);
        }
        if (this.sslConfig.isSslEnable()) {
            final SSLContext sslContext = this.sslConfig.getSslContext();
            SslPlugin sslPlugin = new SslPlugin(new SSLContextFactory(){

                public SSLContext create() throws Exception {
                    return sslContext;
                }

                public void initSSLEngine(SSLEngine sslEngine) {
                    sslEngine.setUseClientMode(false);
                }
            });
            _config.addPlugin((Plugin)sslPlugin);
            this.isSecure = true;
        }
        _config.debug(this.enableDebug);
        _config.bannerEnabled(false);
        _config.readBufferSize(8192);
        _config.threadNum(this.coreThreads);
        _config.setHttpIdleTimeout(this.props.getIdleTimeoutOrDefault());
        if (this.enableWebSocket && (wsProps = WebSocketServerProps.getInstance()).getIdleTimeout() > 0L) {
            _config.setWsIdleTimeout(wsProps.getIdleTimeout());
        }
        if (ServerProps.request_maxHeaderSize > 0) {
            _config.readBufferSize(ServerProps.request_maxHeaderSize);
        }
        if (ServerProps.request_maxBodySize > 0L) {
            _config.setMaxRequestSize(ServerProps.request_maxBodySize);
        }
        SmHttpContextHandler handlerTmp = new SmHttpContextHandler(this.handler);
        handlerTmp.setExecutor(this.workExecutor);
        EventBus.publish((Object)_config);
        this.server.httpHandler((HttpServerHandler)handlerTmp);
        if (this.enableWebSocket) {
            this.server.webSocketHandler((WebSocketHandler)new SmWebSocketHandleImpl());
        }
        this.server.setPort(port);
        this.server.start();
    }

    public void stop() throws Throwable {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
        }
    }
}

