/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jetty;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.noear.solon.Solon;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.server.jetty.JettyServer;
import org.noear.solon.server.jetty.jsp.JspLifeCycle;
import org.noear.solon.server.jetty.jsp.JspTldLocator;
import org.noear.solon.server.prop.impl.HttpServerProps;
import org.noear.solon.server.util.DebugUtils;

public class JettyServerAddJsp
extends JettyServer {
    public JettyServerAddJsp(HttpServerProps props) {
        super(props);
    }

    @Override
    protected ServletContextHandler buildHandler() throws IOException, URISyntaxException {
        ServletContextHandler handler = this.getServletHandler();
        String resRoot = this.getResourceRoot();
        handler.setResourceBase(resRoot);
        this.addJspSupport(handler);
        this.addTdlSupport((ServletContext)handler.getServletContext());
        return handler;
    }

    private void addJspSupport(ServletContextHandler handler) throws IOException {
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        handler.setClassLoader((ClassLoader)jspClassLoader);
        handler.addBean((Object)new JspLifeCycle(handler));
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        handler.addServlet(holderJsp, "*.jsp");
    }

    private void addTdlSupport(ServletContext servletContext) throws IOException {
        Map<String, TaglibDescriptor> tagLibInfos = JspTldLocator.createTldInfos("WEB-INF", "templates");
        if (tagLibInfos.size() > 0) {
            ServletContextHandler.JspConfig jspConfig = (ServletContextHandler.JspConfig)servletContext.getJspConfigDescriptor();
            if (jspConfig == null) {
                jspConfig = new ServletContextHandler.JspConfig();
                ((ServletContextHandler.Context)servletContext).setJspConfigDescriptor((JspConfigDescriptor)jspConfig);
            }
            for (TaglibDescriptor descriptor : tagLibInfos.values()) {
                jspConfig.addTaglibDescriptor(descriptor);
            }
        }
    }

    private String getResourceRoot() throws FileNotFoundException {
        File dir;
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            if (NativeDetector.inNativeImage()) {
                return "";
            }
            throw new FileNotFoundException("Unable to find root");
        }
        if (Solon.cfg().isDebugMode() && Solon.cfg().isFilesMode() && (dir = DebugUtils.getDebugLocation((ClassLoader)AppClassLoader.global(), (String)"/")) != null) {
            return dir.toURI().getPath();
        }
        return rootURL.getPath();
    }

    private URL getRootPath() {
        URL root = ResourceUtil.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            URL temp = ResourceUtil.getResource((String)"");
            if (temp == null) {
                return null;
            }
            String path = temp.toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

