/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jetty;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.server.ServerLifecycle;
import org.noear.solon.server.jetty.HandlerHub;
import org.noear.solon.server.jetty.JettyServerBase;
import org.noear.solon.server.prop.impl.HttpServerProps;

public class JettyServer
extends JettyServerBase
implements ServerLifecycle {
    protected Server real = null;
    protected boolean enableWebSocket;

    public JettyServer(HttpServerProps props) {
        super(props);
    }

    public void enableWebSocket(boolean enableWebSocket) {
        this.enableWebSocket = enableWebSocket;
    }

    public void start(String host, int port) throws Throwable {
        this.setup(host, port);
        this.real.start();
    }

    public void stop() throws Throwable {
        if (this.real != null) {
            this.real.stop();
            this.real = null;
        }
    }

    protected void setup(String host, int port) throws IOException, URISyntaxException {
        QueuedThreadPool threadPool = new QueuedThreadPool(this.props.getMaxThreads(this.props.isIoBound()), this.props.getCoreThreads());
        this.real = new Server((ThreadPool)threadPool);
        this.real.addConnector((Connector)this.getConnector(this.real, host, port, true));
        for (Integer portAdd : this.addHttpPorts) {
            this.real.addConnector((Connector)this.getConnector(this.real, host, portAdd, false));
        }
        if (this.enableSessionState) {
            this.real.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this.real));
        }
        if (this.enableWebSocket && ClassUtil.hasClass(() -> UpgradeRequest.class)) {
            this.real.setHandler((Handler)new HandlerHub((Handler)this.buildHandler()));
        } else {
            this.real.setHandler((Handler)this.buildHandler());
        }
        EventBus.publish((Object)this.real);
    }

    protected ServletContextHandler buildHandler() throws IOException, URISyntaxException {
        return this.getServletHandler();
    }
}

