/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jetty;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.noear.solon.server.jetty.JettyServer;
import org.noear.solon.server.jetty.jsp.JspLifeCycle;
import org.noear.solon.server.jetty.jsp.JspTldLocator;
import org.noear.solon.server.prop.impl.HttpServerProps;

public class JettyServerAddJsp
extends JettyServer {
    public JettyServerAddJsp(HttpServerProps props) {
        super(props);
    }

    @Override
    protected ServletContextHandler buildHandler() throws IOException {
        ServletContextHandler handler = this.getServletHandler();
        this.addJspSupport(handler);
        this.addTdlSupport((ServletContext)handler.getServletContext());
        return handler;
    }

    private void addJspSupport(ServletContextHandler handler) throws IOException {
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        handler.setClassLoader((ClassLoader)jspClassLoader);
        handler.addBean((Object)new JspLifeCycle(handler));
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        handler.addServlet(holderJsp, "*.jsp");
    }

    private void addTdlSupport(ServletContext servletContext) throws IOException {
        Map<String, TaglibDescriptor> tagLibInfos = JspTldLocator.createTldInfos("WEB-INF", "templates");
        if (tagLibInfos.size() > 0) {
            ServletContextHandler.JspConfig jspConfig = (ServletContextHandler.JspConfig)servletContext.getJspConfigDescriptor();
            if (jspConfig == null) {
                jspConfig = new ServletContextHandler.JspConfig();
                ((ServletContextHandler.Context)servletContext).setJspConfigDescriptor((JspConfigDescriptor)jspConfig);
            }
            for (TaglibDescriptor descriptor : tagLibInfos.values()) {
                jspConfig.addTaglibDescriptor(descriptor);
            }
        }
    }
}

