/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.jdkhttp;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.jdkhttp.JdkHttpContext;
import org.noear.solon.server.jdkhttp.integration.JdkHttpPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkHttpContextHandler
implements HttpHandler {
    static final Logger log = LoggerFactory.getLogger(JdkHttpContextHandler.class);
    private final Handler handler;

    public JdkHttpContextHandler(Handler handler) {
        this.handler = handler;
    }

    @Override
    public void handle(HttpExchange exchange) {
        try {
            this.handleDo(exchange);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        finally {
            exchange.close();
        }
    }

    protected void handleDo(HttpExchange exchange) throws IOException {
        JdkHttpContext ctx = new JdkHttpContext(exchange);
        try {
            ctx.contentType("text/plain;charset=UTF-8");
            if (ServerProps.output_meta) {
                ctx.headerSet("Solon-Boot", JdkHttpPlugin.solon_boot_ver());
            }
            this.handler.handle((Context)ctx);
            if (ctx.asyncStarted()) {
                ctx.asyncAwait();
            } else {
                ctx.innerCommit();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
            exchange.sendResponseHeaders(500, -1L);
        }
    }
}

