/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.snack4;

import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.Options;
import org.noear.snack4.codec.ObjectEncoder;
import org.noear.solon.Utils;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntityStringSerializer;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil2;
import org.noear.solon.serialization.snack4.Snack4Decl;

public class Snack4StringSerializer
implements EntityStringSerializer {
    private static final String label = "/json";
    private static final Snack4StringSerializer _default = new Snack4StringSerializer();
    private Snack4Decl serializeConfig;
    private Snack4Decl deserializeConfig;

    public static Snack4StringSerializer getDefault() {
        return _default;
    }

    public Snack4StringSerializer(JsonProps jsonProps) {
        this.loadJsonProps(jsonProps);
    }

    public Snack4StringSerializer() {
    }

    public Snack4Decl getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new Snack4Decl();
        }
        return this.serializeConfig;
    }

    public Snack4Decl getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new Snack4Decl();
        }
        return this.deserializeConfig;
    }

    public String mimeType() {
        return "application/json";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label) || mime.startsWith("application/x-ndjson");
    }

    public String name() {
        return "snack3-json";
    }

    public String serialize(Object obj) throws IOException {
        return ONode.ofBean((Object)obj, (Options)this.getSerializeConfig().getOptions()).toJson();
    }

    public Object deserialize(String data, Type toType) throws IOException {
        if (toType == null) {
            return ONode.ofJson((String)data, (Options)this.getDeserializeConfig().getOptions()).toBean();
        }
        return ONode.ofJson((String)data, (Options)this.getDeserializeConfig().getOptions()).toBean(toType);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return ONode.ofJson((String)data, (Options)this.getDeserializeConfig().getOptions());
        }
        return null;
    }

    public <T> void addEncoder(Class<T> clz, ObjectEncoder<T> encoder) {
        this.getSerializeConfig().getOptions().addEncoder(clz, encoder);
    }

    public <T> void addEncoder(Class<T> clz, Converter<T, Object> converter) {
        this.addEncoder(clz, (ctx, value, target) -> {
            Object val = converter.convert(value);
            if (val == null) {
                return target.setValue(null);
            }
            if (val instanceof String) {
                return target.setValue(val);
            }
            if (val instanceof Number) {
                return target.setValue(val);
            }
            throw new IllegalArgumentException("The result type of the converter is not supported: " + clz.getName());
        });
    }

    protected void loadJsonProps(JsonProps jsonProps) {
        if (jsonProps != null) {
            JsonPropsUtil2.dateAsFormat((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.dateAsTicks((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.boolAsInt((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.longAsString((EntityStringSerializer)this, (JsonProps)jsonProps);
            if (jsonProps.nullStringAsEmpty) {
                this.getSerializeConfig().addFeatures(Feature.Write_NullStringAsEmpty);
            }
            if (jsonProps.nullBoolAsFalse) {
                this.getSerializeConfig().addFeatures(Feature.Write_NullBooleanAsFalse);
            }
            if (jsonProps.nullNumberAsZero) {
                this.getSerializeConfig().addFeatures(Feature.Write_NullNumberAsZero);
            }
            if (jsonProps.nullArrayAsEmpty) {
                this.getSerializeConfig().addFeatures(Feature.Write_NullListAsEmpty);
            }
            if (jsonProps.nullAsWriteable) {
                this.getSerializeConfig().addFeatures(Feature.Write_Nulls);
            }
            if (jsonProps.enumAsName) {
                this.getSerializeConfig().addFeatures(Feature.Write_EnumUsingName);
            }
        }
    }
}

