/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.snack3;

import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.snack.core.NodeEncoder;
import org.noear.snack.core.Options;
import org.noear.solon.Utils;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.EntityStringSerializer;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil2;
import org.noear.solon.serialization.snack3.SnackDecl;

public class SnackStringSerializer
implements EntityStringSerializer {
    private static final String label = "/json";
    private static final SnackStringSerializer _default = new SnackStringSerializer();
    private SnackDecl serializeConfig;
    private SnackDecl deserializeConfig;

    public static SnackStringSerializer getDefault() {
        return _default;
    }

    public SnackStringSerializer(JsonProps jsonProps) {
        this.loadJsonProps(jsonProps);
    }

    public SnackStringSerializer() {
    }

    public SnackDecl getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new SnackDecl();
        }
        return this.serializeConfig;
    }

    public SnackDecl getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new SnackDecl();
        }
        return this.deserializeConfig;
    }

    public String mimeType() {
        return "application/json";
    }

    public Class<String> dataType() {
        return String.class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.contains(label) || mime.startsWith("application/x-ndjson");
    }

    public String name() {
        return "snack3-json";
    }

    public String serialize(Object obj) throws IOException {
        return ONode.loadObj((Object)obj, (Options)this.getSerializeConfig().getOptions()).toJson();
    }

    public Object deserialize(String data, Type toType) throws IOException {
        if (toType == null) {
            return ONode.loadStr((String)data, (Options)this.getDeserializeConfig().getOptions());
        }
        return ONode.loadStr((String)data, (Options)this.getDeserializeConfig().getOptions()).toObject(toType);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType(this.mimeType());
        }
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        String data = ctx.bodyNew();
        if (Utils.isNotEmpty((String)data)) {
            return ONode.loadStr((String)data, (Options)this.getDeserializeConfig().getOptions());
        }
        return null;
    }

    public <T> void addEncoder(Class<T> clz, NodeEncoder<T> encoder) {
        this.getSerializeConfig().getOptions().addEncoder(clz, encoder);
    }

    public <T> void addEncoder(Class<T> clz, Converter<T, Object> converter) {
        this.addEncoder(clz, (source, target) -> {
            Object val = converter.convert(source);
            if (val == null) {
                target.asNull();
            } else if (val instanceof String) {
                target.val().setString((String)val);
            } else if (val instanceof Number) {
                target.val().setNumber((Number)val);
            } else {
                throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
            }
        });
    }

    protected void loadJsonProps(JsonProps jsonProps) {
        if (jsonProps != null) {
            JsonPropsUtil2.dateAsFormat((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.dateAsTicks((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.boolAsInt((EntityStringSerializer)this, (JsonProps)jsonProps);
            JsonPropsUtil2.longAsString((EntityStringSerializer)this, (JsonProps)jsonProps);
            if (jsonProps.nullStringAsEmpty) {
                this.getSerializeConfig().addFeatures(Feature.StringNullAsEmpty);
            }
            if (jsonProps.nullBoolAsFalse) {
                this.getSerializeConfig().addFeatures(Feature.BooleanNullAsFalse);
            }
            if (jsonProps.nullNumberAsZero) {
                this.getSerializeConfig().addFeatures(Feature.NumberNullAsZero);
            }
            if (jsonProps.nullArrayAsEmpty) {
                this.getSerializeConfig().addFeatures(Feature.ArrayNullAsEmpty);
            }
            if (jsonProps.nullAsWriteable) {
                this.getSerializeConfig().addFeatures(Feature.SerializeNulls);
            }
            if (jsonProps.enumAsName) {
                this.getSerializeConfig().addFeatures(Feature.EnumUsingName);
            }
        }
    }
}

