/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.snack3;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.AbstractStringEntityConverter;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.snack3.SnackStringSerializer;

public class SnackEntityConverter
extends AbstractStringEntityConverter<SnackStringSerializer> {
    public SnackEntityConverter(SnackStringSerializer serializer) {
        super((EntitySerializer)serializer);
        serializer.getDeserializeConfig().addFeatures(Feature.DisableClassNameRead);
        serializer.getSerializeConfig().addFeatures(Feature.EnumUsingName);
    }

    public String[] mappings() {
        return new String[]{"@json"};
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ((SnackStringSerializer)this.serializer).deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        Object bodyObj = bodyRef.get();
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        ONode tmp = (ONode)bodyObj;
        if (tmp.isObject()) {
            if (!p.spec().isRequiredBody() && tmp.contains(p.spec().getName())) {
                if (p.spec().isGenericType()) {
                    return tmp.get(p.spec().getName()).toObject((Type)p.getGenericType());
                }
                return tmp.get(p.spec().getName()).toObject(pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyRef);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.toObject((Type)p.getGenericType());
            }
            return tmp.toObject(pt);
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.toObject((Type)p.getGenericType());
            }
            return tmp.toObject(pt);
        }
        return tmp.val().getRaw();
    }
}

