/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.snack3;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.snack.core.Options;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.mvc.ActionExecuteHandlerDefault;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.snack3.SnackStringSerializer;

public class SnackActionExecutor
extends ActionExecuteHandlerDefault {
    private SnackStringSerializer serializer = new SnackStringSerializer();

    public SnackActionExecutor() {
        this.serializer.getConfig().add(new Feature[]{Feature.DisableClassNameRead});
    }

    public SnackStringSerializer getSerializer() {
        return this.serializer;
    }

    public Options config() {
        return this.serializer.getConfig();
    }

    public boolean matched(Context ctx, String mime) {
        return this.serializer.matched(ctx, mime);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return this.serializer.deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        ONode tmp = (ONode)bodyObj;
        if (tmp.isObject()) {
            if (!p.spec().isRequiredBody() && tmp.contains(p.getName())) {
                if (p.spec().isGenericType()) {
                    return tmp.get(p.getName()).toObject((Type)p.getGenericType());
                }
                return tmp.get(p.getName()).toObject(pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.toObject((Type)p.getGenericType());
            }
            return tmp.toObject(pt);
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.toObject((Type)p.getGenericType());
            }
            return tmp.toObject(pt);
        }
        return tmp.val().getRaw();
    }
}

