/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.lang.reflect.Type;
import org.noear.solon.core.handle.Context;
import org.noear.solon.lang.Nullable;
import org.noear.solon.serialization.ContextSerializer;

public class ProtostuffBytesSerializer
implements ContextSerializer<byte[]> {
    private static final String label = "application/protobuf";
    private final Schema<DataWrapper> WRAPPER_SCHEMA = RuntimeSchema.createFrom(DataWrapper.class);

    public String mimeType() {
        return label;
    }

    public Class<byte[]> dataType() {
        return byte[].class;
    }

    public boolean matched(Context ctx, String mime) {
        if (mime == null) {
            return false;
        }
        return mime.startsWith(label);
    }

    public String name() {
        return "protostuff-bytes";
    }

    public byte[] serialize(Object obj) throws IOException {
        LinkedBuffer buffer = LinkedBuffer.allocate();
        try {
            DataWrapper<Object> serializerObj = DataWrapper.builder(obj);
            Schema<DataWrapper> schema = this.WRAPPER_SCHEMA;
            byte[] byArray = ProtostuffIOUtil.toByteArray(serializerObj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            buffer.clear();
        }
    }

    public Object deserialize(byte[] data, Type toType) throws IOException {
        try {
            DataWrapper wrapper = new DataWrapper();
            ProtostuffIOUtil.mergeFrom((byte[])data, wrapper, this.WRAPPER_SCHEMA);
            return wrapper.getData();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        ctx.contentType(this.mimeType());
        ctx.output(this.serialize(data));
    }

    public Object deserializeFromBody(Context ctx, @Nullable Type bodyType) throws IOException {
        return this.deserialize(ctx.bodyAsBytes(), (Type)null);
    }

    public static class DataWrapper<T> {
        private T data;

        public static <T> DataWrapper<T> builder(T data) {
            DataWrapper<T> wrapper = new DataWrapper<T>();
            wrapper.setData(data);
            return wrapper;
        }

        public void setData(T data) {
            this.data = data;
        }

        public T getData() {
            return this.data;
        }
    }
}

