/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.properties;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.snack.core.Feature;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.AbstractStringEntityConverter;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.properties.PropertiesStringSerializer;

public class PropertiesEntityConverter
extends AbstractStringEntityConverter<PropertiesStringSerializer> {
    public PropertiesEntityConverter(PropertiesStringSerializer serializer) {
        super((EntitySerializer)serializer);
        serializer.getConfig().add(new Feature[]{Feature.DisableClassNameRead});
    }

    public String[] mappings() {
        return new String[]{"@properties"};
    }

    public boolean canRead(Context ctx, String mime) {
        if (((PropertiesStringSerializer)this.serializer).allowGet() && MethodType.GET.name.equals(ctx.method()) || ((PropertiesStringSerializer)this.serializer).allowPostForm() && (ctx.isFormUrlencoded() || ctx.isMultipartFormData())) {
            for (String key : ctx.paramMap().keySet()) {
                if (key.indexOf(46) <= 0 && key.indexOf(91) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ((PropertiesStringSerializer)this.serializer).deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        Object bodyObj = bodyRef.get();
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        ONode tmp = (ONode)bodyObj;
        if (tmp.isObject()) {
            if (!p.spec().isRequiredBody() && tmp.contains(p.spec().getName())) {
                if (p.spec().isGenericType()) {
                    return tmp.get(p.spec().getName()).toObject((Type)p.getGenericType());
                }
                return tmp.get(p.spec().getName()).toObject(pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyRef);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.toObject((Type)p.getGenericType());
            }
            return tmp.toObject(pt);
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.toObject((Type)p.getGenericType());
            }
            return tmp.toObject(pt);
        }
        return tmp.val().getRaw();
    }
}

