/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson3;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.core.util.Assert;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.cfg.ConfigFeature;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.module.SimpleModule;

public class Jackson3Decl<F extends ConfigFeature> {
    private ObjectMapper mapper = new ObjectMapper();
    private Set<F> featuresSet = new HashSet<F>();
    private SimpleModule customModule = new SimpleModule();

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"mapper can't be null");
        this.mapper = mapper;
    }

    public SimpleModule getCustomModule() {
        return this.customModule;
    }

    public void setFeatures(F ... features) {
        this.featuresSet.clear();
        this.featuresSet.addAll(Arrays.asList(features));
    }

    public void addFeatures(F ... features) {
        this.featuresSet.addAll(Arrays.asList(features));
    }

    public void removeFeatures(F ... features) {
        this.featuresSet.removeAll(Arrays.asList(features));
    }

    protected void refresh() {
        MapperBuilder builder = this.mapper.rebuild();
        for (ConfigFeature f1 : this.featuresSet) {
            if (f1 instanceof SerializationFeature) {
                builder.configure((SerializationFeature)f1, true);
                continue;
            }
            if (!(f1 instanceof DeserializationFeature)) continue;
            builder.configure((DeserializationFeature)f1, true);
        }
        if (this.customModule != null) {
            builder.addModule((JacksonModule)this.customModule);
        }
        this.mapper = builder.build();
    }
}

