/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson3.impl;

import java.lang.reflect.Field;
import java.util.Collection;
import org.noear.solon.serialization.prop.JsonProps;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;

public class NullValueSerializerImpl
extends ValueSerializer<Object> {
    private JsonProps jsonProps;
    public Class<?> type0;

    public NullValueSerializerImpl(JsonProps jsonProps) {
        this.jsonProps = jsonProps;
    }

    public NullValueSerializerImpl(JsonProps jsonProps, JavaType type) {
        this.jsonProps = jsonProps;
        this.type0 = type == null ? Object.class : type.getRawClass();
    }

    public void serialize(Object value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        Class<?> type = this.type0;
        if (type == null) {
            try {
                if (gen.currentValue() != null) {
                    String fieldName = gen.streamWriteContext().currentName();
                    Field field = gen.currentValue().getClass().getDeclaredField(fieldName);
                    type = field.getType();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (type != null) {
            if (this.jsonProps.nullStringAsEmpty && type == String.class) {
                gen.writeString("");
                return;
            }
            if (this.jsonProps.nullBoolAsFalse && type == Boolean.class) {
                if (this.jsonProps.boolAsInt) {
                    gen.writeNumber(0);
                } else {
                    gen.writeBoolean(false);
                }
                return;
            }
            if (this.jsonProps.nullNumberAsZero && Number.class.isAssignableFrom(type)) {
                if (this.jsonProps.longAsString && type == Long.class) {
                    gen.writeString("0");
                } else if (type == Long.class) {
                    gen.writeNumber(0L);
                } else if (type == Double.class) {
                    gen.writeNumber(0.0);
                } else if (type == Float.class) {
                    gen.writeNumber(0.0f);
                } else {
                    gen.writeNumber(0);
                }
                return;
            }
            if (this.jsonProps.nullArrayAsEmpty && (Collection.class.isAssignableFrom(type) || type.isArray())) {
                gen.writeStartArray();
                gen.writeEndArray();
                return;
            }
        }
        gen.writeNull();
    }
}

