/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.AbstractStringEntityConverter;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.jackson3.Jackson3StringSerializer;
import org.noear.solon.serialization.jackson3.impl.TimeDeserializer;
import org.noear.solon.serialization.jackson3.impl.TypeReferenceImpl;
import tools.jackson.core.FormatFeature;
import tools.jackson.core.TreeNode;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.datatype.jsr310.JavaTimeModule;

public class Jackson3EntityConverter
extends AbstractStringEntityConverter<Jackson3StringSerializer> {
    public Jackson3EntityConverter(Jackson3StringSerializer serializer) {
        super((EntitySerializer)serializer);
        serializer.getDeserializeConfig().setMapper(this.newMapper(new JacksonModule[]{new JavaTimeModule()}));
        serializer.getDeserializeConfig().getCustomModule().addDeserializer(LocalDateTime.class, new TimeDeserializer<LocalDateTime>(LocalDateTime.class));
        serializer.getDeserializeConfig().getCustomModule().addDeserializer(LocalDate.class, new TimeDeserializer<LocalDate>(LocalDate.class));
        serializer.getDeserializeConfig().getCustomModule().addDeserializer(LocalTime.class, new TimeDeserializer<LocalTime>(LocalTime.class));
        serializer.getDeserializeConfig().getCustomModule().addDeserializer(Date.class, new TimeDeserializer<Date>(Date.class));
        ObjectMapper mapper = serializer.getSerializeConfig().getMapper();
        mapper.serializationConfig().with((DatatypeFeature)DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS);
        serializer.getSerializeConfig().setMapper(mapper);
    }

    public String[] mappings() {
        return new String[]{"@json"};
    }

    public ObjectMapper newMapper(JacksonModule ... modules) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectMapper customMapper = mapper.rebuild().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).changeDefaultVisibility(vc -> vc.withVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY)).activateDefaultTypingAsProperty(mapper._deserializationContext().getConfig().getPolymorphicTypeValidator(), DefaultTyping.JAVA_LANG_OBJECT, "@type").addModules(modules).build();
        customMapper.serializationConfig().with((FormatFeature)JsonReadFeature.ALLOW_UNQUOTED_PROPERTY_NAMES);
        customMapper.serializationConfig().with((FormatFeature)JsonReadFeature.ALLOW_SINGLE_QUOTES);
        return customMapper;
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ((Jackson3StringSerializer)this.serializer).deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        Object bodyObj = bodyRef.get();
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        JsonNode tmp = (JsonNode)bodyObj;
        if (tmp.isObject()) {
            if (!p.spec().isRequiredBody() && tmp.has(p.spec().getName())) {
                JsonNode m1 = tmp.get(p.spec().getName());
                return ((Jackson3StringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((Jackson3StringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)m1), new TypeReferenceImpl(p));
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyRef);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            return ((Jackson3StringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((Jackson3StringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        if (tmp.isArray()) {
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            return ((Jackson3StringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((Jackson3StringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        if (tmp.isValueNode()) {
            return ((Jackson3StringSerializer)this.serializer).getDeserializeConfig().getMapper().readValue(((Jackson3StringSerializer)this.serializer).getDeserializeConfig().getMapper().treeAsTokens((TreeNode)tmp), new TypeReferenceImpl(p));
        }
        return null;
    }
}

