/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.core.util.Assert;

public class JacksonDecl<F extends ConfigFeature> {
    private ObjectMapper mapper = new ObjectMapper();
    private Set<F> featuresSet = new HashSet<F>();
    private SimpleModule customModule = new SimpleModule();

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"mapper can't be null");
        this.mapper = mapper;
    }

    public SimpleModule getCustomModule() {
        return this.customModule;
    }

    public void setFeatures(F ... features) {
        this.featuresSet.clear();
        this.featuresSet.addAll(Arrays.asList(features));
    }

    public void addFeatures(F ... features) {
        this.featuresSet.addAll(Arrays.asList(features));
    }

    public void removeFeatures(F ... features) {
        this.featuresSet.removeAll(Arrays.asList(features));
    }

    protected void refresh() {
        for (ConfigFeature f1 : this.featuresSet) {
            if (f1 instanceof SerializationFeature) {
                this.mapper.enable((SerializationFeature)f1);
                continue;
            }
            if (!(f1 instanceof DeserializationFeature)) continue;
            this.mapper.enable((DeserializationFeature)f1);
        }
        if (this.customModule != null) {
            this.mapper.registerModule((Module)this.customModule);
        }
    }
}

