/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.impl;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.noear.solon.core.util.DateUtil;

public class TimeDeserializer<T>
extends JsonDeserializer<T> {
    private final Class<T> type;

    public TimeDeserializer(Class<T> type) {
        this.type = type;
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        String val = jsonParser.getValueAsString();
        try {
            Date date = DateUtil.parse((String)val);
            if (date == null) {
                return null;
            }
            if (this.type == LocalDateTime.class) {
                return (T)LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            }
            if (this.type == LocalDate.class) {
                return (T)LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
            }
            if (this.type == LocalTime.class) {
                return (T)LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalTime();
            }
            if (this.type == ZonedDateTime.class) {
                return (T)ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            }
            if (this.type == OffsetDateTime.class) {
                return (T)OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            }
            if (this.type == OffsetTime.class) {
                return (T)OffsetTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            }
            if (this.type == Instant.class) {
                return (T)date.toInstant();
            }
            if (this.type == Date.class) {
                return (T)date;
            }
            return null;
        }
        catch (Exception ex) {
            throw new JsonParseException(jsonParser, this.type.getSimpleName() + " parse fail: '" + val + "'", (Throwable)ex);
        }
    }
}

