/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import java.io.IOException;
import java.util.Date;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.jackson.JacksonStringSerializer;

public abstract class JacksonRenderFactoryBase
implements JsonRenderFactory {
    protected final JacksonStringSerializer serializer = new JacksonStringSerializer();

    public JacksonStringSerializer getSerializer() {
        return this.serializer;
    }

    public ObjectMapper config() {
        return this.getSerializer().getConfig();
    }

    public <T> void addEncoder(Class<T> clz, JsonSerializer<T> encoder) {
        this.getSerializer().getCustomModule().addSerializer(clz, encoder);
    }

    public <T> void addConvertor(final Class<T> clz, final Converter<T, Object> converter) {
        if (clz == Date.class) {
            this.addEncoder((Class<T>)Date.class, (JsonSerializer<T>)new DateSerializer(){

                public void serialize(Date date, JsonGenerator out, SerializerProvider sp) throws IOException {
                    if (this._customFormat == null) {
                        JacksonRenderFactoryBase.writeDefaultValue(converter, clz.cast(date), out);
                    } else {
                        super.serialize(date, out, sp);
                    }
                }
            });
        } else {
            this.addEncoder(clz, new JsonSerializer<T>(){

                public void serialize(T source, JsonGenerator out, SerializerProvider sp) throws IOException {
                    JacksonRenderFactoryBase.writeDefaultValue(converter, source, out);
                }
            });
        }
    }

    private static <T> void writeDefaultValue(Converter<T, Object> converter, T source, JsonGenerator out) throws IOException {
        Object val = converter.convert(source);
        if (val == null) {
            out.writeNull();
        } else if (val instanceof String) {
            out.writeString((String)val);
        } else if (val instanceof Number) {
            if (val instanceof Integer || val instanceof Long) {
                out.writeNumber(((Number)val).longValue());
            } else {
                out.writeNumber(((Number)val).doubleValue());
            }
        } else {
            throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
        }
    }
}

