/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.impl;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.Collection;
import java.util.List;
import org.noear.solon.serialization.jackson.impl.NullValueSerializerImpl;
import org.noear.solon.serialization.prop.JsonProps;

public class NullBeanSerializerModifierImpl
extends BeanSerializerModifier {
    private JsonProps jsonProps;

    public NullBeanSerializerModifierImpl(JsonProps jsonProps) {
        this.jsonProps = jsonProps;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        for (BeanPropertyWriter beanProperty : beanProperties) {
            BeanPropertyWriter writer = beanProperty;
            if (this.isArrayType(writer)) {
                writer.assignNullSerializer((JsonSerializer)new NullValueSerializerImpl(this.jsonProps, writer.getType()));
                continue;
            }
            if (this.isNumberType(writer)) {
                writer.assignNullSerializer((JsonSerializer)new NullValueSerializerImpl(this.jsonProps, writer.getType()));
                continue;
            }
            if (this.isBooleanType(writer)) {
                writer.assignNullSerializer((JsonSerializer)new NullValueSerializerImpl(this.jsonProps, writer.getType()));
                continue;
            }
            if (!this.isStringType(writer)) continue;
            writer.assignNullSerializer((JsonSerializer)new NullValueSerializerImpl(this.jsonProps, writer.getType()));
        }
        return super.changeProperties(config, beanDesc, beanProperties);
    }

    private boolean isArrayType(BeanPropertyWriter writer) {
        Class clazz = writer.getType().getRawClass();
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    private boolean isStringType(BeanPropertyWriter writer) {
        Class clazz = writer.getType().getRawClass();
        return CharSequence.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz);
    }

    private boolean isNumberType(BeanPropertyWriter writer) {
        Class clazz = writer.getType().getRawClass();
        return Number.class.isAssignableFrom(clazz);
    }

    private boolean isBooleanType(BeanPropertyWriter writer) {
        Class clazz = writer.getType().getRawClass();
        return clazz.equals(Boolean.class);
    }
}

