/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson.xml;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.util.Date;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.jackson.xml.JacksonXmlStringSerializer;

public abstract class JacksonXmlRenderFactoryBase
implements JsonRenderFactory {
    protected final JacksonXmlStringSerializer serializer = new JacksonXmlStringSerializer();

    public JacksonXmlStringSerializer getSerializer() {
        return this.serializer;
    }

    public XmlMapper config() {
        return this.getSerializer().getConfig();
    }

    public <T> void addEncoder(Class<T> clz, JsonSerializer<T> encoder) {
        this.serializer.getCustomModule().addSerializer(clz, encoder);
    }

    public <T> void addConvertor(final Class<T> clz, final Converter<T, Object> converter) {
        if (clz == Date.class) {
            this.addEncoder((Class<T>)Date.class, (JsonSerializer<T>)new DateSerializer(){

                public void serialize(Date date, JsonGenerator out, SerializerProvider sp) throws IOException {
                    if (this._customFormat == null) {
                        JacksonXmlRenderFactoryBase.writeDefaultValue(converter, clz.cast(date), out);
                    } else {
                        super.serialize(date, out, sp);
                    }
                }
            });
        } else {
            this.addEncoder(clz, new JsonSerializer<T>(){

                public void serialize(T source, JsonGenerator out, SerializerProvider sp) throws IOException {
                    JacksonXmlRenderFactoryBase.writeDefaultValue(converter, source, out);
                }
            });
        }
    }

    private static <T> void writeDefaultValue(Converter<T, Object> converter, T source, JsonGenerator out) throws IOException {
        Object val = converter.convert(source);
        if (val == null) {
            out.writeNull();
        } else if (val instanceof String) {
            out.writeString((String)val);
        } else if (val instanceof Number) {
            if (val instanceof Integer || val instanceof Long) {
                out.writeNumber(((Number)val).longValue());
            } else {
                out.writeNumber(((Number)val).doubleValue());
            }
        } else {
            throw new IllegalArgumentException("The result type of the converter is not supported: " + val.getClass().getName());
        }
    }
}

