/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.AbstractStringEntityConverter;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.gson.GsonStringSerializer;
import org.noear.solon.serialization.gson.impl.DateReadAdapter;

public class GsonEntityConverter
extends AbstractStringEntityConverter<GsonStringSerializer> {
    public GsonEntityConverter(GsonStringSerializer serializer) {
        super((EntitySerializer)serializer);
        serializer.getDeserializeConfig().getBuilder().registerTypeAdapter(Date.class, (Object)new DateReadAdapter());
    }

    public String[] mappings() {
        return new String[]{"@json"};
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ((GsonStringSerializer)this.serializer).deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        Object bodyObj = bodyRef.get();
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (bodyObj instanceof JsonObject) {
            JsonObject tmp = (JsonObject)bodyObj;
            if (!p.spec().isRequiredBody() && tmp.has(p.spec().getName())) {
                if (p.spec().isGenericType()) {
                    return ((GsonStringSerializer)this.serializer).deserialize(tmp.get(p.spec().getName()), (Type)p.getGenericType());
                }
                return ((GsonStringSerializer)this.serializer).deserialize(tmp.get(p.spec().getName()), (Type)pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyRef);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return ((GsonStringSerializer)this.serializer).deserialize((JsonElement)tmp, (Type)p.getGenericType());
            }
            return ((GsonStringSerializer)this.serializer).deserialize((JsonElement)tmp, (Type)pt);
        }
        if (bodyObj instanceof JsonArray) {
            JsonArray tmp = (JsonArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return ((GsonStringSerializer)this.serializer).deserialize((JsonElement)tmp, (Type)p.getGenericType());
            }
            return ((GsonStringSerializer)this.serializer).deserialize((JsonElement)tmp, (Type)pt);
        }
        return bodyObj;
    }
}

