/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.mvc.ActionExecuteHandlerDefault;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.gson.GsonStringSerializer;
import org.noear.solon.serialization.gson.impl.DateReadAdapter;

public class GsonActionExecutor
extends ActionExecuteHandlerDefault {
    private final GsonStringSerializer serializer = new GsonStringSerializer();

    public GsonActionExecutor() {
        this.serializer.getConfig().registerTypeAdapter(Date.class, (Object)new DateReadAdapter());
    }

    public GsonStringSerializer getSerializer() {
        return this.serializer;
    }

    @Deprecated
    public GsonBuilder config() {
        return this.serializer.getConfig();
    }

    public boolean matched(Context ctx, String ct) {
        return this.serializer.matched(ctx, ct);
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return this.serializer.deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (p.isRequiredPath() || p.isRequiredCookie() || p.isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (!p.isRequiredBody() && ctx.paramMap().containsKey(p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj instanceof JsonObject) {
            JsonObject tmp = (JsonObject)bodyObj;
            if (!p.isRequiredBody() && tmp.has(p.getName())) {
                if (p.isGenericType()) {
                    return this.serializer.getGson().fromJson(tmp.get(p.getName()), p.getGenericType());
                }
                return this.serializer.getGson().fromJson(tmp.get(p.getName()), pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.isGenericType()) {
                return this.serializer.getGson().fromJson((JsonElement)tmp, p.getGenericType());
            }
            return this.serializer.getGson().fromJson((JsonElement)tmp, pt);
        }
        if (bodyObj instanceof JsonArray) {
            JsonArray tmp = (JsonArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.isGenericType()) {
                return this.serializer.getGson().fromJson((JsonElement)tmp, p.getGenericType());
            }
            return this.serializer.getGson().fromJson((JsonElement)tmp, pt);
        }
        return bodyObj;
    }
}

