/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.AbstractStringEntityConverter;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.fastjson.FastjsonStringSerializer;

public class FastjsonEntityConverter
extends AbstractStringEntityConverter<FastjsonStringSerializer> {
    public FastjsonEntityConverter(FastjsonStringSerializer serializer) {
        super((EntitySerializer)serializer);
        serializer.getSerializeConfig().addFeatures((SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
    }

    public String[] mappings() {
        return new String[]{"@json"};
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ((FastjsonStringSerializer)this.serializer).deserializeFromBody(ctx);
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        if (p.spec().isRequiredPath() || p.spec().isRequiredCookie() || p.spec().isRequiredHeader()) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (!p.spec().isRequiredBody() && ctx.paramMap().containsKey(p.spec().getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        Object bodyObj = bodyRef.get();
        if (bodyObj == null) {
            return super.changeValue(ctx, p, pi, pt, bodyRef);
        }
        if (bodyObj instanceof JSONObject) {
            JSONObject tmp = (JSONObject)bodyObj;
            if (!p.spec().isRequiredBody() && tmp.containsKey((Object)p.spec().getName())) {
                if (p.spec().isGenericType()) {
                    return tmp.getObject(p.spec().getName(), (Type)p.getGenericType());
                }
                return tmp.getObject(p.spec().getName(), pt);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyRef);
            }
            if (List.class.isAssignableFrom(pt)) {
                return null;
            }
            if (pt.isArray()) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.toJavaObject((Type)p.getGenericType());
            }
            return tmp.toJavaObject(pt);
        }
        if (bodyObj instanceof JSONArray) {
            JSONArray tmp = (JSONArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            if (p.spec().isGenericType()) {
                return tmp.toJavaObject((Type)p.getGenericType());
            }
            return tmp.toJavaObject(pt);
        }
        return bodyObj;
    }
}

