/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.sbe.solon;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;
import org.agrona.sbe.solon.SbeSerializable;

public class SbeInput {
    private DirectBuffer buffer;
    private int currentOffset = 0;

    public SbeInput wrap(DirectBuffer buffer) {
        return this.wrap(buffer, 0);
    }

    public SbeInput wrap(DirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.currentOffset = offset;
        return this;
    }

    public int readInt() {
        int intValue = this.buffer.getInt(this.currentOffset);
        this.currentOffset += 4;
        return intValue;
    }

    public long readLong() {
        long longValue = this.buffer.getLong(this.currentOffset);
        this.currentOffset += 8;
        return longValue;
    }

    public float readFloat() {
        float floatValue = this.buffer.getFloat(this.currentOffset);
        this.currentOffset += 4;
        return floatValue;
    }

    public double readDouble() {
        double doubleValue = this.buffer.getDouble(this.currentOffset);
        this.currentOffset += 8;
        return doubleValue;
    }

    public byte readByte() {
        byte byteValue = this.buffer.getByte(this.currentOffset);
        ++this.currentOffset;
        return byteValue;
    }

    public char readChar() {
        char charValue = this.buffer.getChar(this.currentOffset);
        this.currentOffset += 2;
        return charValue;
    }

    public boolean readBoolean() {
        byte booleanByte = this.buffer.getByte(this.currentOffset);
        ++this.currentOffset;
        return booleanByte == 1;
    }

    public short readShort() {
        short shortValue = this.buffer.getShort(this.currentOffset);
        this.currentOffset += 2;
        return shortValue;
    }

    public String readString() {
        return new String(this.readByteArray());
    }

    public BigInteger readBigInteger() {
        return new BigInteger(this.readByteArray());
    }

    public BigDecimal readBigDecimal() {
        return new BigDecimal(this.readString());
    }

    public long[] readLongArray() {
        int length = this.readInt();
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.readLong();
        }
        return longs;
    }

    public int[] readIntArray() {
        int length = this.readInt();
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this.readInt();
        }
        return ints;
    }

    public float[] readFloatArray() {
        int length = this.readInt();
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            floats[i] = this.readFloat();
        }
        return floats;
    }

    public double[] readDoubleArray() {
        int length = this.readInt();
        double[] doubles = new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this.readDouble();
        }
        return doubles;
    }

    public short[] readShortArray() {
        int length = this.readInt();
        short[] shorts = new short[length];
        for (int i = 0; i < length; ++i) {
            shorts[i] = this.readShort();
        }
        return shorts;
    }

    public byte[] readByteArray() {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.readByte();
        }
        return bytes;
    }

    public char[] readCharArray() {
        int length = this.readInt();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = this.readChar();
        }
        return chars;
    }

    public <T extends SbeSerializable> T readObject(Function<SbeInput, T> creator) {
        if (this.readBoolean()) {
            SbeSerializable object = (SbeSerializable)creator.apply(this);
            object.serializeRead(this);
            return (T)object;
        }
        return null;
    }

    public <T> T[] readArray(Function<SbeInput, T> creator, IntFunction<T[]> arrayCreator) {
        int length = this.readInt();
        T[] array = arrayCreator.apply(length);
        for (int i = 0; i < length; ++i) {
            array[i] = creator.apply(this);
        }
        return array;
    }

    public <T> List<T> readList(Function<SbeInput, T> creator) {
        int length = this.readInt();
        ArrayList<T> list = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            list.add(creator.apply(this));
        }
        return list;
    }

    public <T> T readNullable(Function<SbeInput, T> creator) {
        return this.readBoolean() ? (T)creator.apply(this) : null;
    }

    public <K, V, M extends Map<K, V>> M readMap(Supplier<M> mapSupplier, Function<SbeInput, K> keyCreator, Function<SbeInput, V> valCreator) {
        int length = this.readInt();
        Map map = (Map)mapSupplier.get();
        for (int i = 0; i < length; ++i) {
            map.put(keyCreator.apply(this), valCreator.apply(this));
        }
        return (M)map;
    }
}

