/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.solon;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.solon.ChrBytesSerializable;

public class ChrBytesUtil {
    public static void writeIntArray(BytesOut<?> bytes, int[] ints) {
        int length = ints.length;
        bytes.writeInt(length);
        for (int i = 0; i < length; ++i) {
            bytes.writeInt(ints[i]);
        }
    }

    public static int[] readIntArray(BytesIn<?> bytes) {
        int length = bytes.readInt();
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = bytes.readInt();
        }
        return ints;
    }

    public static void writeLongArray(BytesOut<?> bytes, long[] longs) {
        int length = longs.length;
        bytes.writeInt(length);
        for (int i = 0; i < length; ++i) {
            bytes.writeLong(longs[i]);
        }
    }

    public static long[] readLongArray(BytesIn<?> bytes) {
        int length = bytes.readInt();
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = bytes.readLong();
        }
        return longs;
    }

    public static <T extends ChrBytesSerializable> void writeArray(BytesOut<?> bytes, T[] array) {
        int length = array.length;
        bytes.writeInt(length);
        for (int i = 0; i < length; ++i) {
            array[i].serializeWrite(bytes);
        }
    }

    public static <T> T[] readArray(BytesIn<?> bytes, Function<BytesIn, T> creator, IntFunction<T[]> arrayCreator) {
        int length = bytes.readInt();
        T[] array = arrayCreator.apply(length);
        for (int i = 0; i < length; ++i) {
            array[i] = creator.apply(bytes);
        }
        return array;
    }

    public static <T extends ChrBytesSerializable> void writeList(BytesOut<?> bytes, List<ChrBytesSerializable> collection) {
        int length = collection.size();
        bytes.writeInt(length);
        collection.forEach(e -> e.serializeWrite(bytes));
    }

    public static <T> List<T> readList(BytesIn<?> bytes, Function<BytesIn, T> creator) {
        int length = bytes.readInt();
        ArrayList<T> list = new ArrayList<T>(length);
        for (int i = 0; i < length; ++i) {
            list.add(creator.apply(bytes));
        }
        return list;
    }

    public static <K, V> void writeMap(BytesOut<?> bytes, Map<K, V> map, BiConsumer<BytesOut<?>, K> keyMarshaller, BiConsumer<BytesOut<?>, V> valMarshaller) {
        int length = map.size();
        bytes.writeInt(length);
        map.forEach((k, v) -> {
            keyMarshaller.accept(bytes, k);
            valMarshaller.accept(bytes, v);
        });
    }

    public static <K, V, M extends Map<K, V>> M readMap(BytesIn<?> bytes, Supplier<M> mapSupplier, Function<BytesIn, K> keyCreator, Function<BytesIn, V> valCreator) {
        int length = bytes.readInt();
        Map map = (Map)mapSupplier.get();
        for (int i = 0; i < length; ++i) {
            map.put(keyCreator.apply(bytes), valCreator.apply(bytes));
        }
        return (M)map;
    }

    public <T> void writeNullable(BytesOut<?> bytes, T object, BiConsumer<T, BytesOut> marshaller) {
        bytes.writeBoolean(object != null);
        if (object != null) {
            marshaller.accept(object, bytes);
        }
    }

    public <T> T readNullable(BytesIn<?> bytes, Function<BytesIn, T> creator) {
        return bytes.readBoolean() ? (T)creator.apply(bytes) : null;
    }
}

